/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core;

import java.util.Objects;
import javax.annotation.Nullable;

public final class Strings {
    private Strings() throws InstantiationException {
        throw new InstantiationException("Cannot instantiate instance of utility class '" + this.getClass().getName() + "'");
    }

    public static String nullToEmpty(@Nullable String string) {
        return string == null ? "" : string;
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String padStart(String string, int minLength, char padChar) {
        Objects.requireNonNull(string);
        String result = string;
        if (string.length() < minLength) {
            StringBuilder sb = new StringBuilder(minLength);
            for (int i = string.length(); i < minLength; ++i) {
                sb.append(padChar);
            }
            result = sb.append(string).toString();
        }
        return result;
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Objects.requireNonNull(string);
        String result = string;
        if (string.length() < minLength) {
            StringBuilder sb = new StringBuilder(minLength);
            sb.append(string);
            for (int i = string.length(); i < minLength; ++i) {
                sb.append(padChar);
            }
            result = sb.toString();
        }
        return result;
    }

    public static String repeat(String string, int count) {
        Objects.requireNonNull(string);
        Strings.checkArgument(count >= 0, "Invalid count: %s", count);
        String result = "";
        if (count > 1) {
            int n;
            int len = string.length();
            long longSize = (long)len * (long)count;
            int size = (int)longSize;
            if ((long)size != longSize) {
                throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
            }
            char[] array = new char[size];
            string.getChars(0, len, array, 0);
            for (n = len; n < size - n; n <<= 1) {
                System.arraycopy(array, 0, array, n, n);
            }
            System.arraycopy(array, 0, array, n, size - n);
            result = new String(array);
        }
        return result;
    }

    public static String commonPrefix(CharSequence a, CharSequence b) {
        int greatestCommonIndex;
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (greatestCommonIndex = 0; greatestCommonIndex < maxPrefixLength && a.charAt(greatestCommonIndex) == b.charAt(greatestCommonIndex); ++greatestCommonIndex) {
        }
        if (Strings.validSurrogatePairAt(a, greatestCommonIndex - 1) || Strings.validSurrogatePairAt(b, greatestCommonIndex - 1)) {
            --greatestCommonIndex;
        }
        return a.subSequence(0, greatestCommonIndex).toString();
    }

    public static String commonSuffix(CharSequence a, CharSequence b) {
        int lowestCommonIndex;
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        int maxSuffixLength = Math.min(a.length(), b.length());
        for (lowestCommonIndex = 0; lowestCommonIndex < maxSuffixLength && a.charAt(a.length() - lowestCommonIndex - 1) == b.charAt(b.length() - lowestCommonIndex - 1); ++lowestCommonIndex) {
        }
        if (Strings.validSurrogatePairAt(a, a.length() - lowestCommonIndex - 1) || Strings.validSurrogatePairAt(b, b.length() - lowestCommonIndex - 1)) {
            --lowestCommonIndex;
        }
        return a.subSequence(a.length() - lowestCommonIndex, a.length()).toString();
    }

    public static String format(@Nullable String template, Object ... args) {
        int placeholderStart;
        Object[] objectArray;
        template = String.valueOf(template);
        if (args == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "(Object[])null";
        } else {
            objectArray = args;
        }
        args = objectArray;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    private static void checkArgument(boolean expression, @Nullable String template, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.format(template, args));
        }
    }
}

