/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class MoreObjects {
    private MoreObjects() throws InstantiationException {
        throw new InstantiationException("Cannot instantiate instance of utility class '" + this.getClass().getName() + "'");
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private static final class ValueHolder {
        private final String name;
        private final Object value;

        public ValueHolder(@Nullable String name, @Nullable Object value) {
            this.name = name;
            this.value = value;
        }

        public boolean isNonNull() {
            return this.value != null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.name != null) {
                builder.append(this.name).append('=');
            }
            if (this.value != null && this.value.getClass().isArray()) {
                Object[] objectArray = new Object[]{this.value};
                String arrayString = Arrays.deepToString(objectArray);
                builder.append(arrayString, 1, arrayString.length() - 1);
            } else {
                builder.append(this.value);
            }
            return builder.toString();
        }
    }

    public static final class ToStringHelper {
        private final String className;
        private final List<ValueHolder> holders = new LinkedList<ValueHolder>();
        private boolean omitNullValues = false;

        private ToStringHelper(String className) {
            this.className = Objects.requireNonNull(className);
        }

        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelper add(String name, @Nullable Object value) {
            Objects.requireNonNull(name);
            this.holders.add(new ValueHolder(name, value));
            return this;
        }

        public ToStringHelper addValue(@Nullable Object value) {
            this.holders.add(new ValueHolder(null, value));
            return this;
        }

        public String toString() {
            String values = this.holders.stream().filter(v -> !this.omitNullValues || v.isNonNull()).map(ValueHolder::toString).collect(Collectors.joining(", "));
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{').append(values).append('}');
            return builder.toString();
        }
    }
}

