/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.auth;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.starchartlabs.alloy.core.Strings;
import org.starchartlabs.alloy.core.Suppliers;
import org.starchartlabs.calamari.core.exception.KeyLoadingException;

public class ApplicationKey
implements Supplier<String> {
    private static final int EXPIRATION_MINUTES = 9;
    private final String githubAppId;
    private final Supplier<String> privateKeySupplier;
    private final Supplier<String> headerSupplier;

    public ApplicationKey(String githubAppId, Supplier<String> privateKeySupplier) {
        this.githubAppId = Objects.requireNonNull(githubAppId);
        this.privateKeySupplier = Objects.requireNonNull(privateKeySupplier);
        this.headerSupplier = Suppliers.map((Supplier)Suppliers.memoizeWithExpiration(this::generateNewPayload, (long)9L, (TimeUnit)TimeUnit.MINUTES), ApplicationKey::toAuthorizationHeader);
    }

    @Override
    public String get() throws KeyLoadingException {
        return this.headerSupplier.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateNewPayload() throws KeyLoadingException {
        String privateKey = this.privateKeySupplier.get();
        try (PEMReader r = new PEMReader((Reader)new StringReader(privateKey));){
            KeyPair keyPair = Optional.ofNullable((KeyPair)r.readObject()).orElseThrow(() -> new KeyLoadingException("Unable to parse valid private key data from provided content"));
            PrivateKey key = keyPair.getPrivate();
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime expiration = now.plusMinutes(Math.min(10, 10));
            JwtBuilder builder = Jwts.builder().setId(null).setIssuedAt(ApplicationKey.toDate(now)).setExpiration(ApplicationKey.toDate(expiration)).setIssuer(this.githubAppId).signWith(SignatureAlgorithm.RS256, (Key)key);
            String string = builder.compact();
            return string;
        }
        catch (IOException e) {
            throw new KeyLoadingException("Error reading signing key", e);
        }
    }

    private static String toAuthorizationHeader(String jwt) {
        Objects.requireNonNull(jwt);
        return Strings.format((String)"Bearer %s", (Object[])new Object[]{jwt});
    }

    private static Date toDate(ZonedDateTime input) {
        Objects.requireNonNull(input);
        Instant instant = input.toInstant();
        return new Date(instant.toEpochMilli());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

