/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.starchartlabs.alloy.core.Strings;
import org.starchartlabs.alloy.core.Suppliers;
import org.starchartlabs.calamari.core.ResponseConditions;
import org.starchartlabs.calamari.core.auth.ApplicationKey;
import org.starchartlabs.calamari.core.exception.KeyLoadingException;

public class InstallationAccessToken
implements Supplier<String> {
    private static final int EXPIRATION_MINUTES = 59;
    private static final Gson GSON = new GsonBuilder().create();
    private final ApplicationKey applicationKey;
    private final String installationAccessTokenUrl;
    private final String userAgent;
    private final OkHttpClient httpClient;
    private final Supplier<String> headerSupplier;

    public InstallationAccessToken(String installationAccessTokenUrl, ApplicationKey applicationKey, String userAgent) {
        this.applicationKey = Objects.requireNonNull(applicationKey);
        this.installationAccessTokenUrl = Objects.requireNonNull(installationAccessTokenUrl);
        this.userAgent = Objects.requireNonNull(userAgent);
        this.httpClient = new OkHttpClient();
        this.headerSupplier = Suppliers.map((Supplier)Suppliers.memoizeWithExpiration(this::generateNewToken, (long)59L, (TimeUnit)TimeUnit.MINUTES), InstallationAccessToken::toAuthorizationHeader);
    }

    @Override
    public String get() {
        return this.headerSupplier.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateNewToken() {
        HttpUrl url = HttpUrl.parse((String)this.installationAccessTokenUrl);
        RequestBody body = RequestBody.create(null, (byte[])new byte[0]);
        Request request = new Request.Builder().post(body).header("Authorization", this.applicationKey.get()).header("Accept", "application/vnd.github.machine-man-preview+json").header("User-Agent", this.userAgent).url(url).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                String string = AccessTokenResponse.fromJson(response.body().string()).getToken();
                return string;
            }
            ResponseConditions.checkRateLimit(response);
            throw new KeyLoadingException(Strings.format((String)"Request exchanging application key for installation token failed (%s - %s)", (Object[])new Object[]{response.code(), response.message()}));
        }
        catch (IOException e) {
            throw new KeyLoadingException("Error requesting or deserializing GitHub installation token response", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InstallationAccessToken forRepository(String repositoryUrl, ApplicationKey applicationKey, String userAgent) {
        Objects.requireNonNull(applicationKey);
        Objects.requireNonNull(repositoryUrl);
        OkHttpClient httpClient = new OkHttpClient();
        HttpUrl url = HttpUrl.parse((String)repositoryUrl).newBuilder().addEncodedPathSegment("installation").build();
        Request request = new Request.Builder().get().header("Authorization", applicationKey.get()).header("Accept", "application/vnd.github.machine-man-preview+json").header("User-Agent", userAgent).url(url).build();
        try (Response response = httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                String installationAccessTokenUrl = InstallationResponse.fromJson(response.body().string()).getAccessTokensUrl();
                InstallationAccessToken installationAccessToken = new InstallationAccessToken(installationAccessTokenUrl, applicationKey, userAgent);
                return installationAccessToken;
            }
            ResponseConditions.checkRateLimit(response);
            throw new RuntimeException("Request unsuccessful (" + response.code() + " - " + response.message() + ")");
        }
        catch (IOException e) {
            throw new KeyLoadingException("Error requesting or deserializing GitHub installation response", e);
        }
    }

    private static String toAuthorizationHeader(String token) {
        Objects.requireNonNull(token);
        return Strings.format((String)"token %s", (Object[])new Object[]{token});
    }

    private static final class InstallationResponse {
        @SerializedName(value="access_tokens_url")
        private final String accessTokensUrl;

        public InstallationResponse(String accessTokensUrl) {
            this.accessTokensUrl = Objects.requireNonNull(accessTokensUrl);
        }

        public String getAccessTokensUrl() {
            return this.accessTokensUrl;
        }

        public static InstallationResponse fromJson(String json) {
            return (InstallationResponse)GSON.fromJson(json, InstallationResponse.class);
        }
    }

    private static final class AccessTokenResponse {
        private final String token;

        public AccessTokenResponse(String token) {
            this.token = Objects.requireNonNull(token);
        }

        public String getToken() {
            return this.token;
        }

        public static AccessTokenResponse fromJson(String json) {
            return (AccessTokenResponse)GSON.fromJson(json, AccessTokenResponse.class);
        }
    }
}

