/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.starchartlabs.alloy.core.Strings;
import org.starchartlabs.alloy.core.Suppliers;
import org.starchartlabs.calamari.core.ResponseConditions;
import org.starchartlabs.calamari.core.auth.ApplicationKey;
import org.starchartlabs.calamari.core.exception.KeyLoadingException;

public class InstallationAccessToken
implements Supplier<String> {
    private static final int EXPIRATION_MINUTES = 59;
    private static final Gson GSON = new GsonBuilder().create();
    private final ApplicationKey applicationKey;
    private final String installationAccessTokenUrl;
    private final String userAgent;
    private final OkHttpClient httpClient;
    private final Supplier<String> headerSupplier;

    public InstallationAccessToken(String installationAccessTokenUrl, ApplicationKey applicationKey, String userAgent) {
        this.applicationKey = Objects.requireNonNull(applicationKey);
        this.installationAccessTokenUrl = Objects.requireNonNull(installationAccessTokenUrl);
        this.userAgent = Objects.requireNonNull(userAgent);
        this.httpClient = new OkHttpClient();
        this.headerSupplier = Suppliers.map((Supplier)Suppliers.memoizeWithExpiration(this::generateNewToken, (long)59L, (TimeUnit)TimeUnit.MINUTES), InstallationAccessToken::toAuthorizationHeader);
    }

    @Override
    public String get() {
        return this.headerSupplier.get();
    }

    /*
     * Exception decompiling
     */
    private String generateNewToken() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InstallationAccessToken forRepository(String repositoryUrl, ApplicationKey applicationKey, String userAgent) {
        Objects.requireNonNull(applicationKey);
        Objects.requireNonNull(repositoryUrl);
        Objects.requireNonNull(userAgent);
        String installationAccessTokenUrl = InstallationAccessToken.getInstallationUrl(repositoryUrl, applicationKey, userAgent);
        return new InstallationAccessToken(installationAccessTokenUrl, applicationKey, userAgent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getInstallationUrl(String repositoryUrl, ApplicationKey applicationKey, String userAgent) {
        Objects.requireNonNull(applicationKey);
        Objects.requireNonNull(repositoryUrl);
        Objects.requireNonNull(userAgent);
        OkHttpClient httpClient = new OkHttpClient();
        HttpUrl url = HttpUrl.parse((String)repositoryUrl).newBuilder().addEncodedPathSegment("installation").build();
        Request request = new Request.Builder().get().header("Authorization", applicationKey.get()).header("Accept", "application/vnd.github.machine-man-preview+json").header("User-Agent", userAgent).url(url).build();
        try (Response response = httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                String string = InstallationResponse.fromJson(response.body().string()).getAccessTokensUrl();
                return string;
            }
            ResponseConditions.checkRateLimit(response);
            throw new RuntimeException("Request unsuccessful (" + response.code() + " - " + response.message() + ")");
        }
        catch (IOException e) {
            throw new KeyLoadingException("Error requesting or deserializing GitHub installation response", e);
        }
    }

    private static String toAuthorizationHeader(String token) {
        Objects.requireNonNull(token);
        return Strings.format((String)"token %s", (Object[])new Object[]{token});
    }

    private static final class InstallationResponse {
        @SerializedName(value="access_tokens_url")
        private final String accessTokensUrl;

        public InstallationResponse(String accessTokensUrl) {
            this.accessTokensUrl = Objects.requireNonNull(accessTokensUrl);
        }

        public String getAccessTokensUrl() {
            return this.accessTokensUrl;
        }

        public static InstallationResponse fromJson(String json) {
            return (InstallationResponse)GSON.fromJson(json, InstallationResponse.class);
        }
    }

    private static final class AccessTokenResponse {
        private final String token;

        public AccessTokenResponse(String token) {
            this.token = Objects.requireNonNull(token);
        }

        public String getToken() {
            return this.token;
        }

        public static AccessTokenResponse fromJson(String json) {
            return (AccessTokenResponse)GSON.fromJson(json, AccessTokenResponse.class);
        }
    }
}

