/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.paging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.starchartlabs.alloy.core.collections.PageIterator;
import org.starchartlabs.calamari.core.ResponseConditions;
import org.starchartlabs.calamari.core.exception.GitHubResponseException;
import org.starchartlabs.calamari.core.paging.PagingLinks;

public class GitHubPageIterator<T>
implements PageIterator<T> {
    private final Supplier<String> authorizationHeader;
    private final String userAgent;
    private final JsonArrayConverter<?, T> itemMapper;
    private final OkHttpClient httpClient;
    private String url;
    private String mediaType;
    private Optional<Long> remainingEstimate;

    public GitHubPageIterator(String url, Supplier<String> authorizationHeader, String userAgent, Function<String, Collection<T>> jsonDeserializer) {
        this(url, authorizationHeader, userAgent, new JsonArrayConverter(jsonDeserializer, Function.identity()), "application/vnd.github.machine-man-preview+json");
    }

    public GitHubPageIterator(String url, Supplier<String> authorizationHeader, String userAgent, Function<String, Collection<T>> jsonDeserializer, String mediaType) {
        this(url, authorizationHeader, userAgent, new JsonArrayConverter(jsonDeserializer, Function.identity()), mediaType);
    }

    private GitHubPageIterator(String url, Supplier<String> authorizationHeader, String userAgent, JsonArrayConverter<?, T> itemMapper, String mediaType) {
        this.authorizationHeader = Objects.requireNonNull(authorizationHeader);
        this.userAgent = Objects.requireNonNull(userAgent);
        this.url = Objects.requireNonNull(url);
        this.itemMapper = Objects.requireNonNull(itemMapper);
        this.mediaType = Objects.requireNonNull(mediaType);
        this.httpClient = new OkHttpClient();
        this.remainingEstimate = Optional.empty();
    }

    public <S> GitHubPageIterator<S> map(Function<T, S> mapperPerElement) {
        Objects.requireNonNull(mapperPerElement);
        return new GitHubPageIterator<T>(this.url, this.authorizationHeader, this.userAgent, this.itemMapper.andThenEach(mapperPerElement));
    }

    public boolean hasNext() {
        return this.url != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more pages may be read from the provided GitHub endpoint");
        }
        try {
            Response response = this.getResponse(this.url);
            if (!response.isSuccessful()) {
                ResponseConditions.checkRateLimit(response);
                throw new GitHubResponseException("Response returned unsuccessfully (" + response.code() + ")");
            }
            PagingLinks pagingLinks = new PagingLinks(response.headers("Link"));
            this.url = pagingLinks.getNextPageUrl().orElse(null);
            this.remainingEstimate = this.estimateRemaining(pagingLinks);
            try (ResponseBody responseBody = response.body();){
                Collection<T> collection = this.itemMapper.apply(responseBody.string());
                return collection;
            }
        }
        catch (IOException e) {
            throw new GitHubResponseException("Error reading response from GitHub", e);
        }
    }

    public PageIterator<T> trySplit() {
        return null;
    }

    public long estimateSize() {
        return this.remainingEstimate.orElse(Long.MAX_VALUE);
    }

    public static GitHubPageIterator<JsonElement> gson(String url, Supplier<String> authorizationHeader, String userAgent) {
        return new GitHubPageIterator<JsonElement>(url, authorizationHeader, userAgent, new JsonElementConverter());
    }

    public static GitHubPageIterator<JsonElement> gson(String url, Supplier<String> authorizationHeader, String userAgent, String mediaType) {
        return new GitHubPageIterator<JsonElement>(url, authorizationHeader, userAgent, new JsonElementConverter(), mediaType);
    }

    private Response getResponse(String url) throws IOException {
        Objects.requireNonNull(url);
        Request request = new Request.Builder().get().header("User-Agent", this.userAgent).header("Accept", this.mediaType).header("Authorization", this.authorizationHeader.get()).url(url).build();
        return this.httpClient.newCall(request).execute();
    }

    private Optional<Long> estimateRemaining(PagingLinks pagingLinks) {
        Objects.requireNonNull(pagingLinks);
        Integer result = null;
        if (this.hasNext()) {
            Optional perPage = Optional.ofNullable(pagingLinks).flatMap(PagingLinks::getNextPageUrl).flatMap(PagingLinks::getPerPage);
            Optional nextPageNumber = Optional.ofNullable(pagingLinks).flatMap(PagingLinks::getNextPageUrl).flatMap(PagingLinks::getPage);
            Optional lastPageNumber = Optional.ofNullable(pagingLinks).flatMap(PagingLinks::getLastPageUrl).flatMap(PagingLinks::getPage);
            if (perPage.isPresent() && nextPageNumber.isPresent() && lastPageNumber.isPresent()) {
                int pagesRemaining = (Integer)lastPageNumber.get() - (Integer)nextPageNumber.get() + 1;
                result = pagesRemaining * (Integer)perPage.get();
            }
        } else {
            result = 0;
        }
        return Optional.ofNullable(result).map(Integer::longValue);
    }

    private static final class JsonElementConverter
    implements Function<String, Collection<JsonElement>> {
        private Gson gson = new GsonBuilder().create();

        @Override
        public Collection<JsonElement> apply(String json) {
            JsonElement element = (JsonElement)this.gson.fromJson(json, JsonElement.class);
            return StreamSupport.stream(element.getAsJsonArray().spliterator(), false).collect(Collectors.toList());
        }
    }

    private static final class JsonArrayConverter<S, T>
    implements Function<String, Collection<T>> {
        private final Function<String, Collection<S>> jsonDeserializer;
        private final Function<S, T> mapperPerElement;

        public JsonArrayConverter(Function<String, Collection<S>> jsonDeserializer, Function<S, T> mapperPerElement) {
            this.jsonDeserializer = Objects.requireNonNull(jsonDeserializer);
            this.mapperPerElement = Objects.requireNonNull(mapperPerElement);
        }

        @Override
        public Collection<T> apply(String json) {
            return this.jsonDeserializer.apply(json).stream().map(this.mapperPerElement).collect(Collectors.toList());
        }

        public <U> JsonArrayConverter<S, U> andThenEach(Function<T, U> mapperPerElement) {
            return new JsonArrayConverter<S, U>(this.jsonDeserializer, this.mapperPerElement.andThen(mapperPerElement));
        }
    }
}

