/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.webhook;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.starchartlabs.alloy.core.Suppliers;

public class WebhookVerifier {
    private final Supplier<HmacUtils> hmacLookup;

    public WebhookVerifier(Supplier<String> secureTokenLookup) {
        Objects.requireNonNull(secureTokenLookup);
        this.hmacLookup = Suppliers.map(secureTokenLookup, token -> new HmacUtils(HmacAlgorithms.HMAC_SHA_1, token));
    }

    public boolean isPayloadLegitimate(@Nullable String securityKey, String payload) {
        Objects.requireNonNull(payload);
        boolean result = false;
        if (securityKey != null) {
            String expected = "sha1=" + this.hmacLookup.get().hmacHex(payload);
            result = Objects.equals(securityKey, expected);
        }
        return result;
    }
}

