/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.paging;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.starchartlabs.alloy.core.MoreObjects;

public class PagingLinks {
    private static final Pattern LINK_PATTERN = Pattern.compile("\\A.*<([A-Za-z0-9\\-._~:/?#\\[\\]@!$&'()*+,;=%]*)>; rel=\"([A-Za-z0-9]*)\"");
    private static final String FIRST_PAGE_REL = "first";
    private static final String PREVIOUS_PAGE_REL = "prev";
    private static final String NEXT_PAGE_REL = "next";
    private static final String LAST_PAGE_REL = "last";
    private static final String PAGE_PARAMETER = "page";
    private static final String PER_PAGE_PARAMETER = "per_page";
    private static final Logger logger = LoggerFactory.getLogger(PagingLinks.class);
    private final Optional<String> firstPageUrl;
    private final Optional<String> previousPageUrl;
    private final Optional<String> nextPageUrl;
    private final Optional<String> lastPageUrl;

    public PagingLinks(Collection<String> links) {
        Objects.requireNonNull(links);
        logger.debug("Link Headers: {}", links);
        String firstUrl = null;
        String prevUrl = null;
        String nextUrl = null;
        String lastUrl = null;
        Collection allLinks = links.stream().flatMap(s -> Arrays.asList(s.split(",")).stream()).map(String::trim).collect(Collectors.toSet());
        for (String link : allLinks) {
            Matcher matcher = LINK_PATTERN.matcher(link);
            if (!matcher.matches()) continue;
            String href = matcher.group(1);
            String rel = matcher.group(2);
            if (Objects.equals(rel, FIRST_PAGE_REL)) {
                firstUrl = href;
                continue;
            }
            if (Objects.equals(rel, PREVIOUS_PAGE_REL)) {
                prevUrl = href;
                continue;
            }
            if (Objects.equals(rel, NEXT_PAGE_REL)) {
                nextUrl = href;
                continue;
            }
            if (!Objects.equals(rel, LAST_PAGE_REL)) continue;
            lastUrl = href;
        }
        this.firstPageUrl = Optional.ofNullable(firstUrl);
        this.previousPageUrl = Optional.ofNullable(prevUrl);
        this.nextPageUrl = Optional.ofNullable(nextUrl);
        this.lastPageUrl = Optional.ofNullable(lastUrl);
    }

    public Optional<String> getFirstPageUrl() {
        return this.firstPageUrl;
    }

    public Optional<String> getPreviousPageUrl() {
        return this.previousPageUrl;
    }

    public Optional<String> getNextPageUrl() {
        return this.nextPageUrl;
    }

    public Optional<String> getLastPageUrl() {
        return this.lastPageUrl;
    }

    public static Optional<Integer> getPage(String url) {
        Objects.requireNonNull(url);
        return Optional.ofNullable(HttpUrl.get((String)url).queryParameter(PAGE_PARAMETER)).flatMap(PagingLinks::getInteger);
    }

    public static Optional<Integer> getPerPage(String url) {
        Objects.requireNonNull(url);
        return Optional.ofNullable(HttpUrl.get((String)url).queryParameter(PER_PAGE_PARAMETER)).flatMap(PagingLinks::getInteger);
    }

    private static Optional<Integer> getInteger(String candidate) {
        Objects.requireNonNull(candidate);
        Integer result = null;
        try {
            result = Integer.valueOf(candidate);
        }
        catch (NumberFormatException e) {
            logger.warn("Non-numeric parameter value encountered: {}", (Object)candidate);
        }
        return Optional.ofNullable(result);
    }

    public int hashCode() {
        return Objects.hash(this.getFirstPageUrl(), this.getPreviousPageUrl(), this.getNextPageUrl(), this.getLastPageUrl());
    }

    public boolean equals(@Nullable Object obj) {
        boolean result = false;
        if (obj instanceof PagingLinks) {
            PagingLinks compare = (PagingLinks)obj;
            result = Objects.equals(compare.getFirstPageUrl(), this.getFirstPageUrl()) && Objects.equals(compare.getPreviousPageUrl(), this.getPreviousPageUrl()) && Objects.equals(compare.getNextPageUrl(), this.getNextPageUrl()) && Objects.equals(compare.getLastPageUrl(), this.getLastPageUrl());
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("firstPageUrl", this.getFirstPageUrl()).add("previousPageUrl", this.getPreviousPageUrl()).add("nextPageUrl", this.getNextPageUrl()).add("lastPageUrl", this.getLastPageUrl()).toString();
    }
}

