/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import org.starchartlabs.alloy.core.Preconditions;
import org.starchartlabs.alloy.core.Strings;
import org.starchartlabs.alloy.core.Suppliers;
import org.starchartlabs.calamari.core.auth.ApplicationKey;

public class InstallationAccessToken
implements Supplier<String> {
    private static final int DEFAULT_EXPIRATION_MINUTES = 58;
    private static final Gson GSON = new GsonBuilder().create();
    private final ApplicationKey applicationKey;
    private final String installationAccessTokenUrl;
    private final String userAgent;
    private final String mediaType;
    private final OkHttpClient httpClient;
    private final Supplier<String> headerSupplier;
    private final int cacheExpirationMinutes;

    public InstallationAccessToken(String installationAccessTokenUrl, ApplicationKey applicationKey, String userAgent) {
        this(installationAccessTokenUrl, applicationKey, userAgent, "application/vnd.github.machine-man-preview+json", 58);
    }

    public InstallationAccessToken(String installationAccessTokenUrl, ApplicationKey applicationKey, String userAgent, String mediaType) {
        this(installationAccessTokenUrl, applicationKey, userAgent, mediaType, 58);
    }

    public InstallationAccessToken(String installationAccessTokenUrl, ApplicationKey applicationKey, String userAgent, String mediaType, int cacheExpirationMinutes) {
        this.applicationKey = Objects.requireNonNull(applicationKey);
        this.installationAccessTokenUrl = Objects.requireNonNull(installationAccessTokenUrl);
        this.userAgent = Objects.requireNonNull(userAgent);
        this.mediaType = Objects.requireNonNull(mediaType);
        Preconditions.checkArgument((cacheExpirationMinutes > 0 ? 1 : 0) != 0, (Object)"Must provide an expiration time greater than zero");
        Preconditions.checkArgument((cacheExpirationMinutes <= 60 ? 1 : 0) != 0, (Object)"Must provide an expiration time less than or equal to 60");
        this.httpClient = new OkHttpClient();
        this.cacheExpirationMinutes = cacheExpirationMinutes;
        this.headerSupplier = Suppliers.map((Supplier)Suppliers.memoizeWithExpiration(this::generateNewToken, (long)this.cacheExpirationMinutes, (TimeUnit)TimeUnit.MINUTES), InstallationAccessToken::toAuthorizationHeader);
    }

    @Override
    public String get() {
        return this.headerSupplier.get();
    }

    /*
     * Exception decompiling
     */
    private String generateNewToken() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InstallationAccessToken forRepository(String repositoryUrl, ApplicationKey applicationKey, String userAgent) {
        return InstallationAccessToken.forRepository(repositoryUrl, applicationKey, userAgent, "application/vnd.github.machine-man-preview+json");
    }

    public static InstallationAccessToken forRepository(String repositoryUrl, ApplicationKey applicationKey, String userAgent, String mediaType) {
        Objects.requireNonNull(applicationKey);
        Objects.requireNonNull(repositoryUrl);
        Objects.requireNonNull(userAgent);
        Objects.requireNonNull(mediaType);
        String installationAccessTokenUrl = InstallationAccessToken.getInstallationUrl(repositoryUrl, applicationKey, userAgent);
        return new InstallationAccessToken(installationAccessTokenUrl, applicationKey, userAgent, mediaType);
    }

    /*
     * Exception decompiling
     */
    public static String getInstallationUrl(String repositoryUrl, ApplicationKey applicationKey, String userAgent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String toAuthorizationHeader(String token) {
        Objects.requireNonNull(token);
        return Strings.format((String)"token %s", (Object[])new Object[]{token});
    }

    private static final class InstallationResponse {
        @SerializedName(value="access_tokens_url")
        private final String accessTokensUrl;

        public InstallationResponse(String accessTokensUrl) {
            this.accessTokensUrl = Objects.requireNonNull(accessTokensUrl);
        }

        public String getAccessTokensUrl() {
            return this.accessTokensUrl;
        }

        public static InstallationResponse fromJson(String json) {
            return (InstallationResponse)GSON.fromJson(json, InstallationResponse.class);
        }
    }

    private static final class AccessTokenResponse {
        private final String token;

        public AccessTokenResponse(String token) {
            this.token = Objects.requireNonNull(token);
        }

        public String getToken() {
            return this.token;
        }

        public static AccessTokenResponse fromJson(String json) {
            return (AccessTokenResponse)GSON.fromJson(json, AccessTokenResponse.class);
        }
    }
}

