/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import okhttp3.Response;
import org.starchartlabs.calamari.core.exception.RequestLimitExceededException;

public class ResponseConditions {
    private static final String RATE_LIMIT_MAXIMUM_HEADER = "X-RateLimit-Limit";
    private static final String RATE_LIMIT_RESET_HEADER = "X-RateLimit-Reset";
    private static final String RATE_LIMIT_REMAINING_HEADER = "X-RateLimit-Remaining";

    public static void checkRateLimit(Response response) throws RequestLimitExceededException {
        Objects.requireNonNull(response);
        ResponseConditions.checkRateLimit(response, Response::code, (res, header) -> res.headers().values(header));
    }

    public static Optional<RequestLimitExceededException> validateRateLimit(Response response) {
        Objects.requireNonNull(response);
        return ResponseConditions.validateRateLimit(response, Response::code, (res, header) -> res.headers().values(header));
    }

    public static <T> void checkRateLimit(T response, Function<T, Integer> codeLookup, BiFunction<T, String, Collection<String>> headerLookup) throws RequestLimitExceededException {
        Objects.requireNonNull(response);
        Objects.requireNonNull(codeLookup);
        Objects.requireNonNull(headerLookup);
        Optional<RequestLimitExceededException> rateLimitViolation = ResponseConditions.validateRateLimit(response, codeLookup, headerLookup);
        if (rateLimitViolation.isPresent()) {
            throw rateLimitViolation.get();
        }
    }

    public static <T> Optional<RequestLimitExceededException> validateRateLimit(T response, Function<T, Integer> codeLookup, BiFunction<T, String, Collection<String>> headerLookup) {
        Objects.requireNonNull(response);
        Objects.requireNonNull(codeLookup);
        Objects.requireNonNull(headerLookup);
        String limit = ((Collection)Optional.ofNullable(headerLookup.apply(response, RATE_LIMIT_MAXIMUM_HEADER)).orElse(Collections.emptyList())).stream().findFirst().orElse("(unknown)");
        String reset = ((Collection)Optional.ofNullable(headerLookup.apply(response, RATE_LIMIT_RESET_HEADER)).orElse(Collections.emptyList())).stream().findFirst().orElse("(unknown)");
        Collection remaining = Optional.ofNullable(headerLookup.apply(response, RATE_LIMIT_REMAINING_HEADER)).orElse(Collections.emptyList());
        boolean rateLimitExceeded = Objects.equals(codeLookup.apply(response), 403) && remaining.contains("0");
        return rateLimitExceeded ? Optional.of(new RequestLimitExceededException(limit, reset)) : Optional.empty();
    }
}

