/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.auth;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.gson.io.GsonSerializer;
import io.jsonwebtoken.io.Serializer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.starchartlabs.alloy.core.Preconditions;
import org.starchartlabs.alloy.core.Strings;
import org.starchartlabs.alloy.core.Suppliers;
import org.starchartlabs.calamari.core.exception.KeyLoadingException;

public class ApplicationKey
implements Supplier<String> {
    private static final int DEFAULT_EXPIRATION_MINUTES = 8;
    private static final Serializer<Map<String, ?>> SERIALIZER = new GsonSerializer();
    private final String githubAppId;
    private final Supplier<String> privateKeySupplier;
    private final Supplier<String> headerSupplier;
    private final int cacheExpirationMinutes;

    public ApplicationKey(String githubAppId, Supplier<String> privateKeySupplier) {
        this(githubAppId, privateKeySupplier, 8);
    }

    public ApplicationKey(String githubAppId, Supplier<String> privateKeySupplier, int cacheExpirationMinutes) {
        this.githubAppId = Objects.requireNonNull(githubAppId);
        this.privateKeySupplier = Objects.requireNonNull(privateKeySupplier);
        Preconditions.checkArgument((cacheExpirationMinutes > 0 ? 1 : 0) != 0, (Object)"Must provide an expiration time greater than zero");
        Preconditions.checkArgument((cacheExpirationMinutes <= 10 ? 1 : 0) != 0, (Object)"Must provide an expiration time less than or equal to 10");
        this.cacheExpirationMinutes = cacheExpirationMinutes;
        this.headerSupplier = Suppliers.map((Supplier)Suppliers.memoizeWithExpiration(this::generateNewPayload, (long)this.cacheExpirationMinutes, (TimeUnit)TimeUnit.MINUTES), ApplicationKey::toAuthorizationHeader);
    }

    @Override
    public String get() throws KeyLoadingException {
        return this.headerSupplier.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateNewPayload() throws KeyLoadingException {
        String privateKey = this.privateKeySupplier.get();
        try (PEMParser r = new PEMParser((Reader)new StringReader(privateKey));){
            PEMKeyPair pemKeyPair = Optional.ofNullable((PEMKeyPair)r.readObject()).orElseThrow(() -> new KeyLoadingException("Unable to parse valid private key data from provided content"));
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair keyPair = converter.getKeyPair(pemKeyPair);
            PrivateKey key = keyPair.getPrivate();
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime expiration = now.plusMinutes(Math.min(this.cacheExpirationMinutes + 1, 10));
            JwtBuilder builder = Jwts.builder().setId(null).serializeToJsonWith(SERIALIZER).setIssuedAt(ApplicationKey.toDate(now)).setExpiration(ApplicationKey.toDate(expiration)).setIssuer(this.githubAppId).signWith((Key)key, SignatureAlgorithm.RS256);
            String string = builder.compact();
            return string;
        }
        catch (IOException e) {
            throw new KeyLoadingException("Error reading signing key", e);
        }
    }

    private static String toAuthorizationHeader(String jwt) {
        Objects.requireNonNull(jwt);
        return Strings.format((String)"Bearer %s", (Object[])new Object[]{jwt});
    }

    private static Date toDate(ZonedDateTime input) {
        Objects.requireNonNull(input);
        Instant instant = input.toInstant();
        return new Date(instant.toEpochMilli());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

