/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.calamari.core.content;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.starchartlabs.alloy.core.Preconditions;
import org.starchartlabs.alloy.core.Strings;
import org.starchartlabs.calamari.core.ResponseConditions;
import org.starchartlabs.calamari.core.auth.InstallationAccessToken;
import org.starchartlabs.calamari.core.exception.FileContentException;
import org.starchartlabs.calamari.core.exception.GitHubResponseException;

public class FileContentLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OkHttpClient httpClient;
    private final String userAgent;
    private final String mediaType;

    public static String decodeFileContent(String encoding, String content) {
        Objects.requireNonNull(encoding);
        Objects.requireNonNull(content);
        String result = null;
        Preconditions.checkArgument((boolean)Objects.equals(encoding, "base64"), (Object)Strings.format((String)"GitHub content responses are expected to be of base64 encoding, got %s - check that requested path is a file", (Object[])new Object[]{encoding}));
        try {
            result = new String(Base64.getMimeDecoder().decode(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IllegalArgumentException e) {
            throw new FileContentException("Error deserializing base64 from GitHub response", e);
        }
        return result;
    }

    public FileContentLoader(String userAgent) {
        this(userAgent, "application/vnd.github.machine-man-preview+json");
    }

    public FileContentLoader(String userAgent, String mediaType) {
        this.userAgent = Objects.requireNonNull(userAgent);
        this.mediaType = Objects.requireNonNull(mediaType);
        this.httpClient = new OkHttpClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> loadContents(InstallationAccessToken installationToken, String repositoryUrl, String ref, String path) {
        Objects.requireNonNull(installationToken);
        Objects.requireNonNull(repositoryUrl);
        Objects.requireNonNull(ref);
        Objects.requireNonNull(path);
        String result = null;
        String responseBody = null;
        Request request = this.createRequest(installationToken, repositoryUrl, ref, path);
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                try (ResponseBody body = response.body();){
                    responseBody = body.string();
                    result = this.deserializeResponse(responseBody);
                }
            } else if (response.code() != 404) {
                ResponseConditions.checkRateLimit(response);
                throw new GitHubResponseException("Request unsuccessful (" + response.code() + " - " + response.message() + ")");
            }
            Optional<Object> optional = Optional.ofNullable(result);
            return optional;
        }
        catch (JsonSyntaxException | IOException e) {
            this.logger.error("Error reading contents: {}", responseBody);
            throw new FileContentException("Error requesting or deserializing GitHub file content response.", e);
        }
    }

    private Request createRequest(InstallationAccessToken installationToken, String repositoryUrl, String ref, String path) {
        HttpUrl url = HttpUrl.parse((String)repositoryUrl).newBuilder().addEncodedPathSegment("contents").addPathSegments(path).addQueryParameter("ref", ref).build();
        return new Request.Builder().get().header("Authorization", installationToken.get()).header("Accept", this.mediaType).header("User-Agent", this.userAgent).url(url).build();
    }

    private String deserializeResponse(String responseBody) {
        Objects.requireNonNull(responseBody);
        ContentResponse content = ContentResponse.fromJson(responseBody);
        return FileContentLoader.decodeFileContent(content.getEncoding(), content.getContent());
    }

    private static final class ContentResponse {
        private static final Gson GSON = new GsonBuilder().create();
        @SerializedName(value="encoding")
        private final String encoding;
        @SerializedName(value="content")
        private final String content;

        public ContentResponse(String encoding, String content) {
            this.encoding = Objects.requireNonNull(encoding);
            this.content = Objects.requireNonNull(content);
        }

        public String getEncoding() {
            return this.encoding;
        }

        public String getContent() {
            return this.content;
        }

        public static ContentResponse fromJson(String json) {
            return (ContentResponse)GSON.fromJson(json, ContentResponse.class);
        }
    }
}

