/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.machete.ssm.parameter;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterResult;
import java.util.Objects;
import java.util.function.Supplier;
import org.starchartlabs.alloy.core.Preconditions;
import org.starchartlabs.alloy.core.Strings;

public class StringParameter
implements Supplier<String> {
    private final AWSSimpleSystemsManagement systemsManagementClient;
    private final String parameterKey;

    private StringParameter(AWSSimpleSystemsManagement systemsManagementClient, String parameterKey) {
        this.systemsManagementClient = Objects.requireNonNull(systemsManagementClient);
        this.parameterKey = Objects.requireNonNull(parameterKey);
    }

    @Override
    public String get() {
        GetParameterRequest getParameterRequest = new GetParameterRequest();
        getParameterRequest.withName(this.parameterKey);
        getParameterRequest.setWithDecryption(Boolean.valueOf(false));
        GetParameterResult result = this.systemsManagementClient.getParameter(getParameterRequest);
        return result.getParameter().getValue();
    }

    public static StringParameter fromEnv(String environmentVariable) {
        return StringParameter.fromEnv(AWSSimpleSystemsManagementClientBuilder.defaultClient(), environmentVariable);
    }

    public static StringParameter fromEnv(AWSSimpleSystemsManagement systemsManagementClient, String environmentVariable) {
        Objects.requireNonNull(systemsManagementClient);
        Objects.requireNonNull(environmentVariable);
        String parameterKey = System.getenv(environmentVariable);
        Preconditions.checkArgument((parameterKey != null ? 1 : 0) != 0, () -> Strings.format((String)"Environment variable '%s' is not set", (Object[])new Object[]{environmentVariable}));
        return new StringParameter(systemsManagementClient, parameterKey);
    }
}

