/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.bean;

import com.google.common.collect.Lists;
import com.novi.serde.Bytes;
import java.util.List;
import java.util.stream.Collectors;
import org.starcoin.bean.ModuleObj;
import org.starcoin.bean.TypeObj;
import org.starcoin.types.Identifier;
import org.starcoin.types.ModuleId;
import org.starcoin.types.ScriptFunction;
import org.starcoin.utils.AccountAddressUtils;

public class ScriptFunctionObj
extends ModuleObj {
    private String functionName;
    private List<TypeObj> tyArgs;
    private List<Bytes> args;

    @Override
    public String toRPCString() {
        return this.getModuleAddress() + "::" + this.getModuleName() + "::" + this.functionName;
    }

    public ScriptFunction toScriptFunction() {
        List<Object> tyAargsTypeTag = Lists.newArrayList();
        if (this.tyArgs != null) {
            tyAargsTypeTag = this.tyArgs.stream().map(TypeObj::toTypeTag).collect(Collectors.toList());
        }
        Identifier name = new Identifier(this.getModuleName());
        ModuleId moduleId = new ModuleId(AccountAddressUtils.create(this.getModuleAddress()), name);
        Identifier function = new Identifier(this.getFunctionName());
        ScriptFunction scriptFunction = new ScriptFunction(moduleId, function, tyAargsTypeTag, this.args);
        return scriptFunction;
    }

    protected ScriptFunctionObj(ScriptFunctionObjBuilder<?, ?> b) {
        super(b);
        this.functionName = ((ScriptFunctionObjBuilder)b).functionName;
        this.tyArgs = ((ScriptFunctionObjBuilder)b).tyArgs;
        this.args = ((ScriptFunctionObjBuilder)b).args;
    }

    public static ScriptFunctionObjBuilder<?, ?> builder() {
        return new ScriptFunctionObjBuilderImpl();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<TypeObj> getTyArgs() {
        return this.tyArgs;
    }

    public List<Bytes> getArgs() {
        return this.args;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setTyArgs(List<TypeObj> tyArgs) {
        this.tyArgs = tyArgs;
    }

    public void setArgs(List<Bytes> args) {
        this.args = args;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptFunctionObj)) {
            return false;
        }
        ScriptFunctionObj other = (ScriptFunctionObj)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        List<TypeObj> this$tyArgs = this.getTyArgs();
        List<TypeObj> other$tyArgs = other.getTyArgs();
        if (this$tyArgs == null ? other$tyArgs != null : !((Object)this$tyArgs).equals(other$tyArgs)) {
            return false;
        }
        List<Bytes> this$args = this.getArgs();
        List<Bytes> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScriptFunctionObj;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        List<TypeObj> $tyArgs = this.getTyArgs();
        result = result * 59 + ($tyArgs == null ? 43 : ((Object)$tyArgs).hashCode());
        List<Bytes> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ScriptFunctionObj(functionName=" + this.getFunctionName() + ", tyArgs=" + this.getTyArgs() + ", args=" + this.getArgs() + ")";
    }

    public static abstract class ScriptFunctionObjBuilder<C extends ScriptFunctionObj, B extends ScriptFunctionObjBuilder<C, B>>
    extends ModuleObj.ModuleObjBuilder<C, B> {
        private String functionName;
        private List<TypeObj> tyArgs;
        private List<Bytes> args;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B functionName(String functionName) {
            this.functionName = functionName;
            return (B)this.self();
        }

        public B tyArgs(List<TypeObj> tyArgs) {
            this.tyArgs = tyArgs;
            return (B)this.self();
        }

        public B args(List<Bytes> args) {
            this.args = args;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScriptFunctionObj.ScriptFunctionObjBuilder(super=" + super.toString() + ", functionName=" + this.functionName + ", tyArgs=" + this.tyArgs + ", args=" + this.args + ")";
        }
    }

    private static final class ScriptFunctionObjBuilderImpl
    extends ScriptFunctionObjBuilder<ScriptFunctionObj, ScriptFunctionObjBuilderImpl> {
        private ScriptFunctionObjBuilderImpl() {
        }

        @Override
        protected ScriptFunctionObjBuilderImpl self() {
            return this;
        }

        @Override
        public ScriptFunctionObj build() {
            return new ScriptFunctionObj(this);
        }
    }
}

