/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.ArrayLen;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.starcoin.types.TraitHelpers;

public final class AccountAddress {
    static final int LENGTH = 16;
    public final @ArrayLen(length=16) List<@Unsigned Byte> value;

    public AccountAddress(@ArrayLen(length=16) List<@Unsigned Byte> value) {
        Objects.requireNonNull(value, "value must not be null");
        this.value = value;
    }

    public static AccountAddress deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.value = TraitHelpers.deserialize_array16_u8_array(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static AccountAddress bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        AccountAddress value = AccountAddress.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static AccountAddress valueOf(byte[] values) {
        if (values.length != 16) {
            throw new IllegalArgumentException("Invalid length for AccountAddress");
        }
        ArrayList<Byte> address = new ArrayList<Byte>(16);
        for (int i = 0; i < 16; ++i) {
            address.add(values[i]);
        }
        return new AccountAddress(address);
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        TraitHelpers.serialize_array16_u8_array(this.value, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountAddress other = (AccountAddress)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
        return value;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[16];
        int i = 0;
        for (Byte item : this.value) {
            bytes[i++] = item;
        }
        return bytes;
    }

    public static final class Builder {
        public @ArrayLen(length=16) List<@Unsigned Byte> value;

        public AccountAddress build() {
            return new AccountAddress(this.value);
        }
    }
}

