/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;
import org.starcoin.types.EventKey;

public final class EventHandle {
    public final @Unsigned Long count;
    public final EventKey key;

    public EventHandle(@Unsigned Long count, EventKey key) {
        Objects.requireNonNull(count, "count must not be null");
        Objects.requireNonNull(key, "key must not be null");
        this.count = count;
        this.key = key;
    }

    public static EventHandle deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.count = deserializer.deserialize_u64();
        builder.key = EventKey.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static EventHandle bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        EventHandle value = EventHandle.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_u64(this.count);
        this.key.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventHandle other = (EventHandle)obj;
        if (!Objects.equals(this.count, other.count)) {
            return false;
        }
        return Objects.equals(this.key, other.key);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.count != null ? this.count.hashCode() : 0);
        value = 31 * value + (this.key != null ? this.key.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public @Unsigned Long count;
        public EventKey key;

        public EventHandle build() {
            return new EventHandle(this.count, this.key);
        }
    }
}

