/*
 * Decompiled with CFR 0.152.
 */
package com.novi.serde;

import java.util.Arrays;
import java.util.Objects;

public final class Bytes {
    private static final Bytes EMPTY = new Bytes(new byte[0]);
    private final byte[] content;

    public Bytes(byte[] content) {
        Objects.requireNonNull(content, "content must not be null");
        this.content = content;
    }

    public static Bytes empty() {
        return EMPTY;
    }

    public static Bytes valueOf(byte[] content) {
        Objects.requireNonNull(content, "content must not be null");
        if (content.length == 0) {
            return EMPTY;
        }
        return new Bytes((byte[])content.clone());
    }

    public byte[] content() {
        return (byte[])this.content.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bytes other = (Bytes)obj;
        return Arrays.equals(this.content, other.content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }
}

