/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2Session;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.starcoin.api.JsonRPCClient;
import org.starcoin.bean.ListResource;
import org.starcoin.bean.ListResourceOption;
import org.starcoin.bean.Resource;

public class StateRPCClient {
    private static Logger logger = LoggerFactory.getLogger(StateRPCClient.class);
    JSONRPC2Session session;

    public StateRPCClient(URL baseUrl) {
        this.session = new JSONRPC2Session(baseUrl);
    }

    public ListResource getState(String address) throws JSONRPC2SessionException {
        JsonRPCClient<ListResource> client = new JsonRPCClient<ListResource>();
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(address);
        ListResourceOption option = new ListResourceOption();
        option.setDecode(true);
        param.add(option);
        try {
            return client.getObjectParseJackson(this.session, "state.list_resource", param, 0, ListResource.class);
        }
        catch (IOException e) {
            logger.error("get state error:", (Throwable)e);
            return null;
        }
    }

    public long getAddressAmount(String address, String token) {
        try {
            ListResource listResource = this.getState(address);
            Map<String, Resource> resourceMap = listResource.getResources();
            JsonNode node = resourceMap.get(this.getResourceMapTokenKey(token)).getJson().get("token");
            if (node != null) {
                return node.get("value").asLong();
            }
        }
        catch (JSONRPC2SessionException e) {
            logger.error("get amount error:", (Throwable)e);
        }
        return 0L;
    }

    private String getResourceMapTokenKey(String token) {
        return "0x00000000000000000000000000000001::Account::Balance<" + token + ">";
    }
}

