/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.starcoin.serde.format.ContainerFormat;
import org.starcoin.serde.format.jackson.utils.MappingUtils;
import org.starcoin.serde.format.snakeyaml.YamlUtils;
import org.starcoin.serde.format.utils.ReferenceUtils;
import org.starcoin.serde.format.utils.TextFileUtils;

public class SerdeGenJavaUtils {
    public static final String WITH_RUNTIMES_SERDE = "--with-runtimes=Serde";
    public static final String WITH_RUNTIMES_BCS = "--with-runtimes=Bcs";
    public static final String DEFAULT_TEMP_YAML_FILE_EXTENSION = ".temp";
    public static final String DEFAULT_SERDEGEN_PATH = "serdegen";
    private static final String JAVA_SOURCE_CLASS_LINE_START = "public final class ";

    public static void processSerdeFormatFiles(String workingDirectory, String serdegenPath, List<SerdeFormatFile> serdeFormatFiles, ObjectMapper objectMapper, String tempYamlFileExtension, Integer onlyRetainDependenciesOfLast) {
        int i;
        if (workingDirectory == null || workingDirectory.isEmpty()) {
            throw new IllegalArgumentException("workingDirectory is null or empty.");
        }
        if (serdegenPath == null || serdegenPath.isEmpty()) {
            throw new IllegalArgumentException("serdegenPath is null or empty.");
        }
        if (tempYamlFileExtension == null || tempYamlFileExtension.isEmpty()) {
            tempYamlFileExtension = DEFAULT_TEMP_YAML_FILE_EXTENSION;
        }
        List yamlMapList = serdeFormatFiles.stream().map(f -> YamlUtils.loadYamlMap(Paths.get(f.getFormatFilePath(), new String[0]))).collect(Collectors.toList());
        List containerFormatMapList = yamlMapList.stream().map(m -> MappingUtils.toContainerFormatMap(objectMapper, m)).collect(Collectors.toList());
        ArrayList<String> onlyRetainedNames = null;
        if (onlyRetainDependenciesOfLast != null) {
            if (onlyRetainDependenciesOfLast < 1) {
                onlyRetainDependenciesOfLast = 1;
            }
            onlyRetainedNames = new ArrayList<String>();
        }
        ArrayList<Map<String, Object>> concatenatedMapList = new ArrayList<Map<String, Object>>();
        for (i = 0; i < serdeFormatFiles.size(); ++i) {
            List<Map<String, Object>> eMaps = yamlMapList.subList(0, i);
            List<Map<String, ContainerFormat>> ecMaps = containerFormatMapList.subList(0, i);
            Map<String, Object> concatenatedMap = ReferenceUtils.includeExternalObjects((Map<String, Object>)((Map)yamlMapList.get(i)), (Map)containerFormatMapList.get(i), ecMaps, eMaps);
            concatenatedMapList.add(concatenatedMap);
            if (onlyRetainDependenciesOfLast == null || i < serdeFormatFiles.size() - onlyRetainDependenciesOfLast) continue;
            onlyRetainedNames.addAll(concatenatedMap.keySet());
        }
        if (onlyRetainDependenciesOfLast != null) {
            for (i = 0; i < concatenatedMapList.size(); ++i) {
                HashMap concatenatedMap = new HashMap();
                for (String n : ((Map)concatenatedMapList.get(i)).keySet()) {
                    if (!onlyRetainedNames.contains(n)) continue;
                    concatenatedMap.put(n, ((Map)concatenatedMapList.get(i)).get(n));
                }
                concatenatedMapList.set(i, concatenatedMap);
            }
        }
        for (i = 0; i < serdeFormatFiles.size(); ++i) {
            int ec_0;
            List<Set<String>> externalNamesList = concatenatedMapList.subList(0, i).stream().map(Map::keySet).collect(Collectors.toList());
            Map concatenatedMap = (Map)concatenatedMapList.get(i);
            String packageName = serdeFormatFiles.get(i).getPackageName();
            String targetSourceDirectoryPath = serdeFormatFiles.get(i).getTargetSourceDirectoryPath();
            String tmpFilePath = serdeFormatFiles.get(i).formatFilePath + tempYamlFileExtension;
            YamlUtils.dumpToFile(Paths.get(tmpFilePath, new String[0]), concatenatedMap);
            if (i == 0 && (ec_0 = SerdeGenJavaUtils.waitForSerdegenProcess(workingDirectory, serdegenPath, packageName, WITH_RUNTIMES_SERDE, targetSourceDirectoryPath, tmpFilePath)) != 0) {
                throw new RuntimeException("Run serdegen command failed.");
            }
            int ec = SerdeGenJavaUtils.waitForSerdegenProcess(workingDirectory, serdegenPath, packageName, WITH_RUNTIMES_BCS, targetSourceDirectoryPath, tmpFilePath);
            if (ec != 0) {
                throw new RuntimeException("Run serdegen command failed.");
            }
            try {
                Files.deleteIfExists(Paths.get(tmpFilePath, new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException("Delete temporary file failed.", e);
            }
            List<String> removedNames = SerdeGenJavaUtils.removeDuplicatedFiles(workingDirectory, packageName, targetSourceDirectoryPath, concatenatedMap, externalNamesList);
            Map containerFormatMap = (Map)containerFormatMapList.get(i);
            SerdeGenJavaUtils.modifyGeneratedFiles(workingDirectory, serdeFormatFiles, externalNamesList, containerFormatMap, i, removedNames, onlyRetainedNames);
        }
    }

    private static void modifyGeneratedFiles(String workingDirectory, List<SerdeFormatFile> serdeFormatFiles, List<Set<String>> externalNamesList, Map<String, ContainerFormat> containerFormatMap, int currentFileIndex, List<String> removedNames, List<String> onlyRetainedNames) {
        String packageName = serdeFormatFiles.get(currentFileIndex).getPackageName();
        String targetSourceDirectoryPath = serdeFormatFiles.get(currentFileIndex).getTargetSourceDirectoryPath();
        ArrayList<String> retainedNames = new ArrayList<String>(containerFormatMap.keySet());
        retainedNames.removeAll(removedNames);
        if (onlyRetainedNames != null) {
            retainedNames.retainAll(onlyRetainedNames);
        }
        retainedNames.forEach(n -> {
            ArrayList<Integer> importPackageIds = new ArrayList<Integer>();
            block0: for (String rn : ((ContainerFormat)containerFormatMap.get(n)).referencedContainerTypeNames()) {
                for (int j = 0; j < externalNamesList.size(); ++j) {
                    if (!((Set)externalNamesList.get(j)).contains(rn)) continue;
                    if (importPackageIds.contains(j)) continue block0;
                    importPackageIds.add(j);
                    continue block0;
                }
            }
            if (!importPackageIds.isEmpty()) {
                Path pathToModify = SerdeGenJavaUtils.getJavaFilePathByTypeName(workingDirectory, packageName, targetSourceDirectoryPath, n);
                String importStr = importPackageIds.stream().map(idx -> "import " + ((SerdeFormatFile)serdeFormatFiles.get((int)idx)).getPackageName() + ".*;").reduce((s1, s2) -> s1 + System.lineSeparator() + s2).get();
                String sourceCode = TextFileUtils.readTextFile(pathToModify);
                int classLineIdx = sourceCode.indexOf(JAVA_SOURCE_CLASS_LINE_START);
                if (classLineIdx != -1) {
                    String newSourceCode = sourceCode.substring(0, classLineIdx) + importStr + System.lineSeparator() + System.lineSeparator() + sourceCode.substring(classLineIdx);
                    TextFileUtils.writeTextFile(pathToModify, newSourceCode);
                }
            }
        });
    }

    private static List<String> removeDuplicatedFiles(String workingDirectory, String packageName, String targetSourceDirectoryPath, Map<String, Object> concatenatedMap, List<Set<String>> externalNamesList) {
        ArrayList<String> namesToRemove = new ArrayList<String>(concatenatedMap.keySet());
        namesToRemove.retainAll(externalNamesList.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        namesToRemove.forEach(n -> {
            Path pathToRemove = SerdeGenJavaUtils.getJavaFilePathByTypeName(workingDirectory, packageName, targetSourceDirectoryPath, n);
            try {
                Files.deleteIfExists(pathToRemove);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return namesToRemove;
    }

    private static Path getJavaFilePathByTypeName(String workingDirectory, String packageName, String targetSourceDirectoryPath, String n) {
        return Paths.get(workingDirectory, targetSourceDirectoryPath, packageName.replace(".", File.separator), n + ".java");
    }

    public static int waitForSerdegenProcess(String workingDirectory, String serdegenPath, String packageName, String withRuntimesOrEmpty, String targetSrcDir, String yamlFilePath) {
        Process process;
        String shellPath = "/bin/sh";
        String cmdFormat = "%1$s --language java --module-name %2$s %3$s --target-source-dir %4$s %5$s";
        String cmd = String.format(cmdFormat, serdegenPath, packageName, withRuntimesOrEmpty, targetSrcDir, yamlFilePath);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(shellPath, "-c", cmd);
            processBuilder.directory(new File(workingDirectory));
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SerdeFormatFile {
        private String formatFilePath;
        private String packageName;
        private String targetSourceDirectoryPath;

        public SerdeFormatFile(String formatFilePath, String packageName, String targetSourceDirectoryPath) {
            this.formatFilePath = formatFilePath;
            this.packageName = packageName;
            this.targetSourceDirectoryPath = targetSourceDirectoryPath;
        }

        public String getFormatFilePath() {
            return this.formatFilePath;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getTargetSourceDirectoryPath() {
            return this.targetSourceDirectoryPath;
        }
    }
}

