/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types.event;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.Int128;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.math.BigInteger;
import java.util.Objects;
import org.starcoin.types.TokenCode;

public final class MintEvent {
    public final @Unsigned @Int128 BigInteger amount;
    public final TokenCode token_code;

    public MintEvent(@Unsigned @Int128 BigInteger amount, TokenCode token_code) {
        Objects.requireNonNull(amount, "amount must not be null");
        Objects.requireNonNull(token_code, "token_code must not be null");
        this.amount = amount;
        this.token_code = token_code;
    }

    public static MintEvent deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.amount = deserializer.deserialize_u128();
        builder.token_code = TokenCode.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static MintEvent bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        MintEvent value = MintEvent.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_u128(this.amount);
        this.token_code.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MintEvent other = (MintEvent)obj;
        if (!Objects.equals(this.amount, other.amount)) {
            return false;
        }
        return Objects.equals(this.token_code, other.token_code);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
        value = 31 * value + (this.token_code != null ? this.token_code.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public @Unsigned @Int128 BigInteger amount;
        public TokenCode token_code;

        public MintEvent build() {
            return new MintEvent(this.amount, this.token_code);
        }
    }
}

