/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.starcoin.types.TransactionPayload;
import org.starcoin.utils.Hex;

public class TransactionPayloadSerializer
extends StdSerializer<TransactionPayload> {
    public TransactionPayloadSerializer() {
        super(TransactionPayload.class);
    }

    public void serialize(TransactionPayload payload, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (payload instanceof TransactionPayload.Script) {
            this.handleScript(jsonGenerator, serializerProvider, (TransactionPayload.Script)payload);
        }
        if (payload instanceof TransactionPayload.ScriptFunction) {
            this.handleScriptFunction(jsonGenerator, serializerProvider, (TransactionPayload.ScriptFunction)payload);
        }
        if (payload instanceof TransactionPayload.Package) {
            this.handlePackage(jsonGenerator, serializerProvider, (TransactionPayload.Package)payload);
        }
    }

    private void handleScript(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TransactionPayload.Script script) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("code", Hex.encode(script.value.code));
        data.put("args", script.value.args.stream().map(arg -> Hex.encode(arg)).collect(Collectors.toList()));
        data.put("type_args", script.value.ty_args);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField("type_name", (Object)"Script");
        jsonGenerator.writeObjectField("value", data);
        jsonGenerator.writeEndObject();
    }

    private void handleScriptFunction(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TransactionPayload.ScriptFunction scriptFunction) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField("type_name", (Object)"ScriptFunction");
        jsonGenerator.writeObjectField("value", (Object)scriptFunction.value);
        jsonGenerator.writeEndObject();
    }

    private void handlePackage(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TransactionPayload.Package pkg) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("modules", pkg.value.modules.stream().map(module -> Hex.encode(module.code)).collect(Collectors.toList()));
        data.put("package_address", Hex.encode(pkg.value.package_address.value));
        if (pkg.value.init_script.isPresent()) {
            data.put("init_script", pkg.value.init_script.get());
        }
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField("type_name", (Object)"Package");
        jsonGenerator.writeObjectField("value", data);
        jsonGenerator.writeEndObject();
    }
}

