/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.starcoin.types.TypeTag;

public final class ArgumentABI {
    public final String name;
    public final TypeTag type_tag;

    public ArgumentABI(String name, TypeTag type_tag) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(type_tag, "type_tag must not be null");
        this.name = name;
        this.type_tag = type_tag;
    }

    public static ArgumentABI deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.name = deserializer.deserialize_str();
        builder.type_tag = TypeTag.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static ArgumentABI bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        ArgumentABI value = ArgumentABI.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_str(this.name);
        this.type_tag.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArgumentABI other = (ArgumentABI)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.type_tag, other.type_tag);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.name != null ? this.name.hashCode() : 0);
        value = 31 * value + (this.type_tag != null ? this.type_tag.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public String name;
        public TypeTag type_tag;

        public ArgumentABI build() {
            return new ArgumentABI(this.name, this.type_tag);
        }
    }
}

