/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.starcoin.types.Ed25519PublicKey;
import org.starcoin.types.Ed25519Signature;
import org.starcoin.types.MultiEd25519PublicKey;
import org.starcoin.types.MultiEd25519Signature;

public abstract class TransactionAuthenticator {
    public static TransactionAuthenticator deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return Ed25519.load(deserializer);
            }
            case 1: {
                return MultiEd25519.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for TransactionAuthenticator: " + index);
    }

    public static TransactionAuthenticator bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        TransactionAuthenticator value = TransactionAuthenticator.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public abstract void serialize(Serializer var1) throws SerializationError;

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static final class MultiEd25519
    extends TransactionAuthenticator {
        public final MultiEd25519PublicKey public_key;
        public final MultiEd25519Signature signature;

        public MultiEd25519(MultiEd25519PublicKey public_key, MultiEd25519Signature signature) {
            Objects.requireNonNull(public_key, "public_key must not be null");
            Objects.requireNonNull(signature, "signature must not be null");
            this.public_key = public_key;
            this.signature = signature;
        }

        static MultiEd25519 load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.public_key = MultiEd25519PublicKey.deserialize(deserializer);
            builder.signature = MultiEd25519Signature.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            this.public_key.serialize(serializer);
            this.signature.serialize(serializer);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultiEd25519 other = (MultiEd25519)obj;
            if (!Objects.equals(this.public_key, other.public_key)) {
                return false;
            }
            return Objects.equals(this.signature, other.signature);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.public_key != null ? this.public_key.hashCode() : 0);
            value = 31 * value + (this.signature != null ? this.signature.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public MultiEd25519PublicKey public_key;
            public MultiEd25519Signature signature;

            public MultiEd25519 build() {
                return new MultiEd25519(this.public_key, this.signature);
            }
        }
    }

    public static final class Ed25519
    extends TransactionAuthenticator {
        public final Ed25519PublicKey public_key;
        public final Ed25519Signature signature;

        public Ed25519(Ed25519PublicKey public_key, Ed25519Signature signature) {
            Objects.requireNonNull(public_key, "public_key must not be null");
            Objects.requireNonNull(signature, "signature must not be null");
            this.public_key = public_key;
            this.signature = signature;
        }

        static Ed25519 load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.public_key = Ed25519PublicKey.deserialize(deserializer);
            builder.signature = Ed25519Signature.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            this.public_key.serialize(serializer);
            this.signature.serialize(serializer);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ed25519 other = (Ed25519)obj;
            if (!Objects.equals(this.public_key, other.public_key)) {
                return false;
            }
            return Objects.equals(this.signature, other.signature);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.public_key != null ? this.public_key.hashCode() : 0);
            value = 31 * value + (this.signature != null ? this.signature.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Ed25519PublicKey public_key;
            public Ed25519Signature signature;

            public Ed25519 build() {
                return new Ed25519(this.public_key, this.signature);
            }
        }
    }
}

