/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types.event;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.starcoin.types.TokenCode;

public final class AcceptTokenEvent {
    public final TokenCode token_code;

    public AcceptTokenEvent(TokenCode token_code) {
        Objects.requireNonNull(token_code, "token_code must not be null");
        this.token_code = token_code;
    }

    public static AcceptTokenEvent deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.token_code = TokenCode.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static AcceptTokenEvent bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        AcceptTokenEvent value = AcceptTokenEvent.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.token_code.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcceptTokenEvent other = (AcceptTokenEvent)obj;
        return Objects.equals(this.token_code, other.token_code);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.token_code != null ? this.token_code.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public TokenCode token_code;

        public AcceptTokenEvent build() {
            return new AcceptTokenEvent(this.token_code);
        }
    }
}

