package org.starcoin.types;


public abstract class ScriptABI {

    public static ScriptABI deserialize(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0:
                return TransactionScript.load(deserializer);
            case 1:
                return ScriptFunction.load(deserializer);
            default:
                throw new com.novi.serde.DeserializationError("Unknown variant index for ScriptABI: " + index);
        }
    }

    public static ScriptABI bcsDeserialize(byte[] input) throws com.novi.serde.DeserializationError {
        if (input == null) {
            throw new com.novi.serde.DeserializationError("Cannot deserialize null array");
        }
        com.novi.serde.Deserializer deserializer = new com.novi.bcs.BcsDeserializer(input);
        ScriptABI value = deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new com.novi.serde.DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    abstract public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError;

    public byte[] bcsSerialize() throws com.novi.serde.SerializationError {
        com.novi.serde.Serializer serializer = new com.novi.bcs.BcsSerializer();
        serialize(serializer);
        return serializer.get_bytes();
    }

    public static final class TransactionScript extends ScriptABI {
        public final TransactionScriptABI value;

        public TransactionScript(TransactionScriptABI value) {
            java.util.Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static TransactionScript load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = TransactionScriptABI.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            TransactionScript other = (TransactionScript) obj;
            if (!java.util.Objects.equals(this.value, other.value)) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TransactionScriptABI value;

            public TransactionScript build() {
                return new TransactionScript(
                        value
                );
            }
        }
    }

    public static final class ScriptFunction extends ScriptABI {
        public final ScriptFunctionABI value;

        public ScriptFunction(ScriptFunctionABI value) {
            java.util.Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static ScriptFunction load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = ScriptFunctionABI.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            ScriptFunction other = (ScriptFunction) obj;
            if (!java.util.Objects.equals(this.value, other.value)) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public ScriptFunctionABI value;

            public ScriptFunction build() {
                return new ScriptFunction(
                        value
                );
            }
        }
    }
}

