/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.starcoin.serde.format.Format;
import org.starcoin.serde.format.IReferenceContainerType;
import org.starcoin.serde.format.NamedFormat;
import org.starcoin.serde.format.NamedVariantFormat;

public abstract class ContainerFormat
implements IReferenceContainerType {

    public static class Enum
    extends ContainerFormat {
        private final Map<Integer, NamedVariantFormat> indexedNamedVariantFormats;

        public Enum(Map<Integer, NamedVariantFormat> indexedNamedVariantFormats) {
            this.indexedNamedVariantFormats = indexedNamedVariantFormats;
        }

        public Map<Integer, NamedVariantFormat> getIndexedNamedVariantFormats() {
            return this.indexedNamedVariantFormats;
        }

        public String toString() {
            return "Enum{indexedNamedVariantFormats=" + this.indexedNamedVariantFormats + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.indexedNamedVariantFormats.values().stream().flatMap(f -> f.referencedContainerTypeNames().stream()).collect(Collectors.toList());
        }
    }

    public static class Struct
    extends ContainerFormat {
        private final List<NamedFormat> namedFormats;

        public Struct(List<NamedFormat> namedFormats) {
            this.namedFormats = namedFormats;
        }

        public List<NamedFormat> getNamedFormats() {
            return this.namedFormats;
        }

        public String toString() {
            return "Struct{namedFormats=" + this.namedFormats + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.namedFormats.stream().flatMap(f -> f.referencedContainerTypeNames().stream()).collect(Collectors.toList());
        }
    }

    public static class TupleStruct
    extends ContainerFormat {
        private final List<Format> formats;

        public TupleStruct(List<Format> formats) {
            this.formats = formats;
        }

        public List<Format> getFormats() {
            return this.formats;
        }

        public String toString() {
            return "TupleStruct{formats=" + this.formats + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.formats.stream().flatMap(f -> f.referencedContainerTypeNames().stream()).collect(Collectors.toList());
        }
    }

    public static class NewTypeStruct
    extends ContainerFormat {
        private final Format format;

        public NewTypeStruct(Format format) {
            this.format = format;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "NewTypeStruct{format=" + this.format + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.format.referencedContainerTypeNames();
        }
    }

    public static class UnitStruct
    extends ContainerFormat {
        public String toString() {
            return "UnitStruct{}";
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return Collections.emptyList();
        }
    }
}

