/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.starcoin.types.Ed25519PrivateKey;
import org.starcoin.types.Ed25519PublicKey;
import org.starcoin.types.Ed25519Signature;
import org.starcoin.types.RawUserTransaction;
import org.starcoin.types.SignedUserTransaction;
import org.starcoin.types.TransactionAuthenticator;
import org.starcoin.utils.HashUtils;
import org.starcoin.utils.Hex;

public class SignatureUtils {
    public static SignedUserTransaction signTxn(Ed25519PrivateKey privateKey, RawUserTransaction rawUserTransaction) {
        byte[] bytes = Bytes.concat((byte[][])new byte[][]{HashUtils.hashPrefix("RawUserTransaction"), rawUserTransaction.bcsSerialize()});
        byte[] signRst = SignatureUtils.ed25519Sign(privateKey, bytes);
        Ed25519PublicKey publicKey = SignatureUtils.getPublicKey(privateKey);
        Ed25519Signature signature = new Ed25519Signature(new com.novi.serde.Bytes(signRst));
        TransactionAuthenticator.Ed25519 transactionAuthenticator = new TransactionAuthenticator.Ed25519(publicKey, signature);
        SignedUserTransaction signedUserTransaction = new SignedUserTransaction(rawUserTransaction, transactionAuthenticator);
        return signedUserTransaction;
    }

    public static String signPersonalMessage(Ed25519PrivateKey privateKey, String message) {
        Ed25519PublicKey publicKey = SignatureUtils.getPublicKey(privateKey);
        byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
        Ed25519Signature signature = new Ed25519Signature(new com.novi.serde.Bytes(messageBytes));
        TransactionAuthenticator.Ed25519 ed25519 = new TransactionAuthenticator.Ed25519(publicKey, signature);
        byte[] bytes = Bytes.concat((byte[][])new byte[][]{HashUtils.hashPrefix("TransactionAuthenticator"), ed25519.bcsSerialize()});
        byte[] signRst = SignatureUtils.ed25519Sign(privateKey, bytes);
        return Hex.encode(signRst);
    }

    public static Ed25519PublicKey getPublicKey(Ed25519PrivateKey privateKey) {
        Ed25519PrivateKeyParameters key = new Ed25519PrivateKeyParameters(privateKey.value.content(), 0);
        Ed25519PublicKeyParameters publicKeyParameters = key.generatePublicKey();
        Ed25519PublicKey publicKey = new Ed25519PublicKey(new com.novi.serde.Bytes(publicKeyParameters.getEncoded()));
        return publicKey;
    }

    public static byte[] ed25519Sign(Ed25519PrivateKey privateKey, byte[] data) {
        Ed25519PrivateKeyParameters key = new Ed25519PrivateKeyParameters(privateKey.value.content(), 0);
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)key);
        signer.update(data, 0, data.length);
        byte[] rst = signer.generateSignature();
        return rst;
    }

    public static Ed25519PrivateKey strToPrivateKey(String privateKeyString) {
        return new Ed25519PrivateKey(new com.novi.serde.Bytes(Hex.decode(privateKeyString)));
    }
}

