/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.starcoin.types.RawUserTransaction;
import org.starcoin.types.TransactionAuthenticator;

public final class SignedUserTransaction {
    public final RawUserTransaction raw_txn;
    public final TransactionAuthenticator authenticator;

    public SignedUserTransaction(RawUserTransaction raw_txn, TransactionAuthenticator authenticator) {
        Objects.requireNonNull(raw_txn, "raw_txn must not be null");
        Objects.requireNonNull(authenticator, "authenticator must not be null");
        this.raw_txn = raw_txn;
        this.authenticator = authenticator;
    }

    public static SignedUserTransaction deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.raw_txn = RawUserTransaction.deserialize(deserializer);
        builder.authenticator = TransactionAuthenticator.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static SignedUserTransaction bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        SignedUserTransaction value = SignedUserTransaction.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.raw_txn.serialize(serializer);
        this.authenticator.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedUserTransaction other = (SignedUserTransaction)obj;
        if (!Objects.equals(this.raw_txn, other.raw_txn)) {
            return false;
        }
        return Objects.equals(this.authenticator, other.authenticator);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.raw_txn != null ? this.raw_txn.hashCode() : 0);
        value = 31 * value + (this.authenticator != null ? this.authenticator.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public RawUserTransaction raw_txn;
        public TransactionAuthenticator authenticator;

        public SignedUserTransaction build() {
            return new SignedUserTransaction(this.raw_txn, this.authenticator);
        }
    }
}

