/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.starcoin.serde.format.Format;
import org.starcoin.serde.format.NamedFormat;
import org.starcoin.serde.format.VariantFormat;
import org.starcoin.serde.format.jackson.ContainerFormatDeserializer;

public class VariantFormatDeserializer
extends JsonDeserializer<VariantFormat> {
    public VariantFormat deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        if (node instanceof TextNode) {
            if ("UNIT".equals(node.asText())) {
                return new VariantFormat.Unit();
            }
        } else if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            String firstFieldName = (String)objectNode.fieldNames().next();
            if ("NEWTYPE".equals(firstFieldName)) {
                JsonNode valueNode = objectNode.get(firstFieldName);
                Format format = (Format)oc.treeToValue((TreeNode)valueNode, Format.class);
                return new VariantFormat.NewType(format);
            }
            if ("TUPLE".equals(firstFieldName)) {
                ArrayNode formatsNode = (ArrayNode)objectNode.get(firstFieldName);
                ArrayList<Format> formats = new ArrayList<Format>();
                for (JsonNode formatNode : formatsNode) {
                    formats.add((Format)oc.treeToValue((TreeNode)formatNode, Format.class));
                }
                return new VariantFormat.Tuple(formats);
            }
            if ("STRUCT".equals(firstFieldName)) {
                ArrayNode namedFormatsNode = (ArrayNode)objectNode.get(firstFieldName);
                List<NamedFormat> namedFormats = ContainerFormatDeserializer.arrayNodeToNamedFormatList(oc, namedFormatsNode);
                return new VariantFormat.Struct(namedFormats);
            }
        }
        throw new JsonParseException(p, "Unknown node type.");
    }
}

