/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.starcoin.serde.format.ContainerFormat;
import org.starcoin.serde.format.jackson.utils.MappingUtils;

public class ReferenceUtils {
    private ReferenceUtils() {
    }

    public static Map<String, Object> includeExternalObjects(Map<String, Object> originMap, ObjectMapper objectMapper, List<Map<String, ContainerFormat>> externalContainerFormatMap, List<Map<String, Object>> externalMaps) {
        Map<String, ContainerFormat> containerFormatMap = MappingUtils.toContainerFormatMap(objectMapper, originMap);
        return ReferenceUtils.includeExternalObjects(originMap, containerFormatMap, externalContainerFormatMap, externalMaps);
    }

    public static Map<String, Object> includeExternalObjects(Map<String, Object> originMap, Map<String, ContainerFormat> containerFormatMap, List<Map<String, ContainerFormat>> externalContainerFormatMap, List<Map<String, Object>> externalMaps) {
        List<String> referencedNames = ReferenceUtils.getReferencedExternalContainerTypeNames(containerFormatMap, externalContainerFormatMap);
        List<Object> referencedValues = ReferenceUtils.findValuesByNames(referencedNames, externalMaps.toArray(new Map[0]));
        Map<String, Object> concatenatedMap = Stream.concat(originMap.entrySet().stream(), IntStream.range(0, referencedNames.size()).mapToObj(n -> new AbstractMap.SimpleEntry(referencedNames.get(n), referencedValues.get(n)))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
        return concatenatedMap;
    }

    public static List<String> getReferencedExternalContainerTypeNames(Map<String, ContainerFormat> containerFormatMap, List<Map<String, ContainerFormat>> externalContainerFormatMap) {
        Stream referencedExternalNameStream = containerFormatMap.entrySet().stream().flatMap(c -> {
            String name = (String)c.getKey();
            ArrayList<Map> allContainerMap = new ArrayList<Map>();
            allContainerMap.add(containerFormatMap);
            allContainerMap.addAll(externalContainerFormatMap);
            List<String> referencedNames = ReferenceUtils.getReferenceNamesRecursively(name, allContainerMap.toArray(new Map[0]));
            referencedNames.removeAll(containerFormatMap.keySet());
            return referencedNames.stream();
        });
        List<String> referencedNames = referencedExternalNameStream.collect(Collectors.toList());
        return referencedNames;
    }

    public static List<Object> findValuesByNames(List<String> names, Map<String, Object> ... maps) {
        return names.stream().map(n -> Arrays.stream(maps).filter(m -> m.containsKey(n)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find name: " + n)).get(n)).collect(Collectors.toList());
    }

    public static List<String> getReferenceNamesRecursively(String name, Map<String, ContainerFormat> ... maps) {
        return ReferenceUtils.getReferenceNamesRecursively(name, (String n) -> ((ContainerFormat)Arrays.stream(maps).filter(m -> m.containsKey(n)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find name: " + n)).get(n)).referencedContainerTypeNames());
    }

    public static List<String> getReferenceNamesRecursively(String name, Function<String, Iterable<String>> getReferencedNames) {
        ArrayList<String> names = new ArrayList<String>();
        ReferenceUtils.addReferencedNamesRecursively(names, name, getReferencedNames);
        return names;
    }

    public static void addReferencedNamesRecursively(Collection<String> referencedNames, String name, Function<String, Iterable<String>> getReferencedNames) {
        for (String n : getReferencedNames.apply(name)) {
            if (referencedNames.contains(n)) continue;
            referencedNames.add(n);
            ReferenceUtils.addReferencedNamesRecursively(referencedNames, n, getReferencedNames);
        }
    }
}

