/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;

public abstract class DataType {
    public static DataType deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return CODE.load(deserializer);
            }
            case 1: {
                return RESOURCE.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for DataType: " + index);
    }

    public static DataType bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        DataType value = DataType.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public abstract void serialize(Serializer var1) throws SerializationError;

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static final class RESOURCE
    extends DataType {
        static RESOURCE load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RESOURCE other = (RESOURCE)obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public RESOURCE build() {
                return new RESOURCE();
            }
        }
    }

    public static final class CODE
    extends DataType {
        static CODE load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CODE other = (CODE)obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public CODE build() {
                return new CODE();
            }
        }
    }
}

