/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types.event;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.HashValue;

public final class UpgradeEvent {
    public final AccountAddress package_address;
    public final HashValue package_hash;
    public final @Unsigned Long version;

    public UpgradeEvent(AccountAddress package_address, HashValue package_hash, @Unsigned Long version) {
        Objects.requireNonNull(package_address, "package_address must not be null");
        Objects.requireNonNull(package_hash, "package_hash must not be null");
        Objects.requireNonNull(version, "version must not be null");
        this.package_address = package_address;
        this.package_hash = package_hash;
        this.version = version;
    }

    public static UpgradeEvent deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.package_address = AccountAddress.deserialize(deserializer);
        builder.package_hash = HashValue.deserialize(deserializer);
        builder.version = deserializer.deserialize_u64();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static UpgradeEvent bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        UpgradeEvent value = UpgradeEvent.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.package_address.serialize(serializer);
        this.package_hash.serialize(serializer);
        serializer.serialize_u64(this.version);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpgradeEvent other = (UpgradeEvent)obj;
        if (!Objects.equals(this.package_address, other.package_address)) {
            return false;
        }
        if (!Objects.equals(this.package_hash, other.package_hash)) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.package_address != null ? this.package_address.hashCode() : 0);
        value = 31 * value + (this.package_hash != null ? this.package_hash.hashCode() : 0);
        value = 31 * value + (this.version != null ? this.version.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public AccountAddress package_address;
        public HashValue package_hash;
        public @Unsigned Long version;

        public UpgradeEvent build() {
            return new UpgradeEvent(this.package_address, this.package_hash, this.version);
        }
    }
}

