/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.google.common.primitives.Bytes;
import org.bouncycastle.jcajce.provider.digest.SHA3;
import org.bouncycastle.util.encoders.Hex;

public class HashUtils {
    public static String hashStarcoinSignedUserTransaction(byte[] signedMessage) {
        byte[] bytesForHash = Bytes.concat((byte[][])new byte[][]{HashUtils.hashWithStarcoinPrefix("SignedUserTransaction"), signedMessage});
        return HashUtils.sha3HashStr(HashUtils.sha3Hash(bytesForHash));
    }

    public static byte[] hashWithStarcoinPrefix(String name) {
        return HashUtils.hash("STARCOIN::".getBytes(), name.getBytes());
    }

    public static byte[] hash(byte[] prefix, byte[] bytes) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        digestSHA3.update(prefix);
        digestSHA3.update(bytes);
        return digestSHA3.digest();
    }

    public static byte[] sha3Hash(byte[] data) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        return digestSHA3.digest(data);
    }

    public static String sha3HashStr(byte[] data) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        return Hex.toHexString((byte[])digestSHA3.digest(data));
    }
}

