/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.novi.serde.Bytes;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.starcoin.bean.ResourceObj;
import org.starcoin.bean.ScriptFunctionObj;
import org.starcoin.bean.TypeObj;
import org.starcoin.stdlib.Helpers;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.AccountResource;
import org.starcoin.types.ChainId;
import org.starcoin.types.Ed25519PrivateKey;
import org.starcoin.types.Module;
import org.starcoin.types.Package;
import org.starcoin.types.RawUserTransaction;
import org.starcoin.types.ScriptFunction;
import org.starcoin.types.SignedUserTransaction;
import org.starcoin.types.TransactionPayload;
import org.starcoin.utils.AccountAddressUtils;
import org.starcoin.utils.ChainInfo;
import org.starcoin.utils.Hex;
import org.starcoin.utils.SignatureUtils;

public class StarcoinClient {
    public static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final long DEFAULT_MAX_GAS_AMOUNT = 10000000L;
    private static final long DEFAULT_TRANSACTION_EXPIRATION_SECONDS = 7200L;
    private static final String GAS_TOKEN_CODE = "0x1::STC::STC";
    private static final String FUNCTION_ID_PRICE_ORACLE_READ = "0x00000000000000000000000000000001::PriceOracle::read";
    private static final String FUNCTION_ID_PRICE_ORACLE_GET_SCALING_FACTOR = "0x00000000000000000000000000000001::PriceOracle::get_scaling_factor";
    private final String baseUrl;
    private final int chaindId;
    private final OkHttpClient okHttpClient = new OkHttpClient.Builder().build();

    public StarcoinClient(String url, int chainId) {
        this.baseUrl = url;
        this.chaindId = chainId;
    }

    public StarcoinClient(ChainInfo chainInfo) {
        this.baseUrl = chainInfo.getUrl();
        this.chaindId = chainInfo.getChainId();
    }

    private static boolean indicatesSuccess(Map<String, Object> responseMap) {
        return !responseMap.containsKey("error");
    }

    public String call(String method, List<Object> params) {
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("jsonrpc", (Object)"2.0");
        jsonBody.put("method", (Object)method);
        jsonBody.put("id", (Object)UUID.randomUUID().toString());
        jsonBody.put("params", params);
        RequestBody body = RequestBody.create((String)jsonBody.toString(), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().post(body).url(this.baseUrl).build();
        Response response = this.okHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public String transfer(AccountAddress sender, Ed25519PrivateKey privateKey, AccountAddress to, TypeObj typeObj, BigInteger amount) {
        TransactionPayload payload = this.buildTransferPayload(to, typeObj, amount);
        return this.submitTransaction(sender, privateKey, payload);
    }

    private TransactionPayload buildTransferPayload(AccountAddress toAddress, TypeObj typeObj, BigInteger amount) {
        return Helpers.encode_peer_to_peer_v2_script_function(typeObj.toTypeTag(), toAddress, amount);
    }

    public String submitHexTransaction(Ed25519PrivateKey privateKey, RawUserTransaction rawUserTransaction) {
        SignedUserTransaction signedUserTransaction = SignatureUtils.signTxn(privateKey, rawUserTransaction);
        ArrayList params = Lists.newArrayList((Object[])new Object[]{Hex.encode(signedUserTransaction.bcsSerialize())});
        return this.call("txpool.submit_hex_transaction", params);
    }

    public String callScriptFunction(AccountAddress sender, Ed25519PrivateKey privateKey, ScriptFunctionObj scriptFunctionObj) {
        TransactionPayload.ScriptFunction scriptFunction = new TransactionPayload.ScriptFunction(scriptFunctionObj.toScriptFunction());
        RawUserTransaction rawUserTransaction = this.buildRawUserTransaction(sender, scriptFunction);
        return this.submitHexTransaction(privateKey, rawUserTransaction);
    }

    public AccountResource getAccountSequence(AccountAddress sender) {
        String path = AccountAddressUtils.hex(sender) + "/1/0x00000000000000000000000000000001::Account::Account";
        String rst = this.call("state.get", Lists.newArrayList((Object[])new Object[]{path}));
        JSONObject jsonObject = JSON.parseObject((String)rst);
        List result = jsonObject.getJSONArray("result").toJavaList(Byte.class);
        Byte[] bytes = result.toArray(new Byte[0]);
        return AccountResource.bcsDeserialize(ArrayUtils.toPrimitive((Byte[])bytes));
    }

    public long getAccountSequenceNumber(AccountAddress sender) {
        AccountResource accountResource = this.getAccountSequence(sender);
        return accountResource.sequence_number;
    }

    private RawUserTransaction buildRawUserTransaction(AccountAddress sender, TransactionPayload payload) {
        long seqNumber = this.getAccountSequenceNumber(sender);
        return this.buildRawUserTransaction(sender, seqNumber, payload);
    }

    private RawUserTransaction buildRawUserTransaction(AccountAddress sender, long seqNumber, TransactionPayload payload) {
        ChainId chainId = new ChainId((byte)this.chaindId);
        return new RawUserTransaction(sender, seqNumber, payload, 10000000L, this.getGasUnitPrice(), GAS_TOKEN_CODE, this.getExpirationTimestampSecs(), chainId);
    }

    private long getExpirationTimestampSecs() {
        String resultStr = this.call("node.info", Collections.emptyList());
        JSONObject jsonObject = JSON.parseObject((String)resultStr);
        return jsonObject.getJSONObject("result").getLong("now_seconds") + 7200L;
    }

    private long getGasUnitPrice() {
        String resultStr = this.call("txpool.gas_price", Collections.emptyList());
        JSONObject jsonObject = JSON.parseObject((String)resultStr);
        return jsonObject.getLong("result");
    }

    public String dryRunTransaction(AccountAddress sender, Ed25519PrivateKey privateKey, TransactionPayload payload) {
        throw new NotImplementedException("");
    }

    private String dryRunHexTransaction(Ed25519PrivateKey privateKey, RawUserTransaction rawUserTransaction) {
        SignedUserTransaction signedUserTransaction = SignatureUtils.signTxn(privateKey, rawUserTransaction);
        ArrayList params = Lists.newArrayList((Object[])new Object[]{Hex.encode(signedUserTransaction.bcsSerialize())});
        return this.call("contract.dry_run_raw", params);
    }

    public String submitTransaction(AccountAddress sender, Ed25519PrivateKey privateKey, TransactionPayload payload) {
        RawUserTransaction rawUserTransaction = this.buildRawUserTransaction(sender, payload);
        return this.submitHexTransaction(privateKey, rawUserTransaction);
    }

    public String submitTransaction(AccountAddress sender, long seqNumber, Ed25519PrivateKey privateKey, TransactionPayload payload) {
        RawUserTransaction rawUserTransaction = this.buildRawUserTransaction(sender, seqNumber, payload);
        return this.submitHexTransaction(privateKey, rawUserTransaction);
    }

    public String deployContractPackage(AccountAddress sender, Ed25519PrivateKey privateKey, String filePath, ScriptFunctionObj initScriptObj) {
        Package contractPackage;
        String fileExt = filePath.substring(filePath.lastIndexOf(".") + 1);
        if ("mv".equalsIgnoreCase(fileExt)) {
            ScriptFunction sf = Objects.isNull(initScriptObj) ? null : initScriptObj.toScriptFunction();
            byte[] contractBytes = Files.toByteArray((File)new File(filePath));
            Module module = new Module(new Bytes(contractBytes));
            contractPackage = new Package(sender, Lists.newArrayList((Object[])new Module[]{module}), Optional.ofNullable(sf));
        } else {
            contractPackage = Package.bcsDeserialize(Files.toByteArray((File)new File(filePath)));
        }
        TransactionPayload.Package.Builder builder = new TransactionPayload.Package.Builder();
        builder.value = contractPackage;
        TransactionPayload.Package payload = builder.build();
        return this.submitTransaction(sender, privateKey, payload);
    }

    public String getTransactionInfo(String txn) {
        return this.call("chain.get_transaction_info", Lists.newArrayList((Object[])new Object[]{txn}));
    }

    public String getResource(AccountAddress sender, ResourceObj resourceObj) {
        return this.call("contract.get_resource", Lists.newArrayList((Object[])new Object[]{AccountAddressUtils.hex(sender), resourceObj.toRPCString()}));
    }

    public BigInteger priceOracleRead(String priceOracleType, String address) {
        String rspBody = this.contractCallV2(FUNCTION_ID_PRICE_ORACLE_READ, Collections.singletonList(priceOracleType), Collections.singletonList(address));
        JSONObject jsonObject = JSON.parseObject((String)rspBody);
        if (!StarcoinClient.indicatesSuccess((Map<String, Object>)jsonObject)) {
            throw new RuntimeException("JSON RPC error: " + jsonObject.get((Object)"error"));
        }
        return new BigInteger(jsonObject.getJSONArray("result").get(0).toString());
    }

    public BigInteger priceOracleGetScalingFactor(String priceOracleType) {
        String rspBody = this.contractCallV2(FUNCTION_ID_PRICE_ORACLE_GET_SCALING_FACTOR, Collections.singletonList(priceOracleType), Collections.emptyList());
        JSONObject jsonObject = JSON.parseObject((String)rspBody);
        if (!StarcoinClient.indicatesSuccess((Map<String, Object>)jsonObject)) {
            throw new RuntimeException("JSON RPC error: " + jsonObject.get((Object)"error"));
        }
        return new BigInteger(jsonObject.getJSONArray("result").get(0).toString());
    }

    public String contractCallV2(String functionId, List<String> typeArgs, List<Object> args) {
        String method = "contract.call_v2";
        HashMap<String, Object> singleParamMap = new HashMap<String, Object>();
        singleParamMap.put("function_id", functionId);
        singleParamMap.put("type_args", typeArgs);
        singleParamMap.put("args", args);
        List<Object> params = Collections.singletonList(singleParamMap);
        return this.call(method, params);
    }
}

