/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.bean;

import java.util.Optional;
import org.starcoin.bean.ModuleObj;
import org.starcoin.bean.TypeObj;

public class ResourceObj
extends ModuleObj {
    private String resourceName;
    private Optional<TypeObj> resourceType = Optional.empty();

    @Override
    public String toRPCString() {
        String rst = this.getModuleAddress() + "::" + this.getModuleName() + "::" + this.getResourceName();
        if (this.resourceType != null && this.resourceType.isPresent()) {
            rst = rst + "<" + this.resourceType.get().toRPCString() + ">";
        }
        return rst;
    }

    protected ResourceObj(ResourceObjBuilder<?, ?> b) {
        super(b);
        this.resourceName = ((ResourceObjBuilder)b).resourceName;
        this.resourceType = ((ResourceObjBuilder)b).resourceType;
    }

    public static ResourceObjBuilder<?, ?> builder() {
        return new ResourceObjBuilderImpl();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Optional<TypeObj> getResourceType() {
        return this.resourceType;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setResourceType(Optional<TypeObj> resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceObj)) {
            return false;
        }
        ResourceObj other = (ResourceObj)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        Optional<TypeObj> this$resourceType = this.getResourceType();
        Optional<TypeObj> other$resourceType = other.getResourceType();
        return !(this$resourceType == null ? other$resourceType != null : !((Object)this$resourceType).equals(other$resourceType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ResourceObj;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        Optional<TypeObj> $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)$resourceType).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ResourceObj(resourceName=" + this.getResourceName() + ", resourceType=" + this.getResourceType() + ")";
    }

    public static abstract class ResourceObjBuilder<C extends ResourceObj, B extends ResourceObjBuilder<C, B>>
    extends ModuleObj.ModuleObjBuilder<C, B> {
        private String resourceName;
        private Optional<TypeObj> resourceType;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B resourceName(String resourceName) {
            this.resourceName = resourceName;
            return (B)this.self();
        }

        public B resourceType(Optional<TypeObj> resourceType) {
            this.resourceType = resourceType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ResourceObj.ResourceObjBuilder(super=" + super.toString() + ", resourceName=" + this.resourceName + ", resourceType=" + this.resourceType + ")";
        }
    }

    private static final class ResourceObjBuilderImpl
    extends ResourceObjBuilder<ResourceObj, ResourceObjBuilderImpl> {
        private ResourceObjBuilderImpl() {
        }

        @Override
        protected ResourceObjBuilderImpl self() {
            return this;
        }

        @Override
        public ResourceObj build() {
            return new ResourceObj(this);
        }
    }
}

