/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.starcoin.serde.format.Format;
import org.starcoin.serde.format.IReferenceContainerType;
import org.starcoin.serde.format.NamedFormat;

public abstract class VariantFormat
implements IReferenceContainerType {

    public static class Struct
    extends VariantFormat {
        private List<NamedFormat> namedFormats;

        public Struct(List<NamedFormat> namedFormats) {
            this.namedFormats = namedFormats;
        }

        public List<NamedFormat> getNamedFormats() {
            return this.namedFormats;
        }

        public String toString() {
            return "Struct{namedFormats=" + this.namedFormats + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.namedFormats.stream().flatMap(f -> f.referencedContainerTypeNames().stream()).collect(Collectors.toList());
        }
    }

    public static class Tuple
    extends VariantFormat {
        private List<Format> formats;

        public Tuple(List<Format> formats) {
            this.formats = formats;
        }

        public List<Format> getFormats() {
            return this.formats;
        }

        public String toString() {
            return "Tuple{formats=" + this.formats + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.formats.stream().flatMap(f -> f.referencedContainerTypeNames().stream()).collect(Collectors.toList());
        }
    }

    public static class NewType
    extends VariantFormat {
        private Format format;

        public NewType(Format format) {
            this.format = format;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "NewType{format=" + this.format + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.format.referencedContainerTypeNames();
        }
    }

    public static class Unit
    extends VariantFormat {
        public String toString() {
            return "Unit{}";
        }

        public List referencedContainerTypeNames() {
            return Collections.EMPTY_LIST;
        }
    }
}

