/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.bouncycastle.jcajce.provider.digest.SHA3;

public final class HashValue {
    public static final int LENGTH = 32;
    public final Bytes value;

    public HashValue(Bytes value) {
        Objects.requireNonNull(value, "value must not be null");
        this.value = value;
    }

    public static HashValue zero() {
        byte[] val = new byte[32];
        return new HashValue(Bytes.valueOf(val));
    }

    public static HashValue sha3Of(byte[] content) {
        byte[] digestedBytes = new SHA3.Digest256().digest(content);
        return new HashValue(Bytes.valueOf(digestedBytes));
    }

    public static HashValue deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.value = deserializer.deserialize_bytes();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static HashValue bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        HashValue value = HashValue.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_bytes(this.value);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashValue other = (HashValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public Bytes value;

        public HashValue build() {
            return new HashValue(this.value);
        }
    }
}

