/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.novi.serde.Bytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.starcoin.utils.Hex;

public class ParseUtil {
    public static <T> T parseObject(JsonParser jsonParser, JsonNode typeTagNode, Class<T> valueType) throws IOException {
        JsonParser parser = typeTagNode.traverse();
        parser.setCodec(jsonParser.getCodec());
        Object t = parser.readValueAs(valueType);
        return (T)t;
    }

    public static Bytes parseBytes(JsonNode typeTagNode) {
        return Bytes.valueOf(Hex.decode(typeTagNode.textValue()));
    }

    public static List<Bytes> parseBytesList(JsonNode typeTagNode) {
        ArrayList<Bytes> result = new ArrayList<Bytes>();
        if (typeTagNode.isArray()) {
            for (JsonNode objNode : typeTagNode) {
                result.add(ParseUtil.parseBytes(objNode));
            }
        }
        return result;
    }

    public static <T> List<T> parseObjectList(JsonParser jsonParser, JsonNode typeTagNode, Class<T> valueType) throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        if (typeTagNode.isArray()) {
            for (JsonNode objNode : typeTagNode) {
                T t = ParseUtil.parseObject(jsonParser, objNode, valueType);
                result.add(t);
            }
        }
        return result;
    }
}

