/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.ChainId;
import org.starcoin.types.SigningMessage;
import org.starcoin.types.TransactionAuthenticator;

public final class SignedMessage {
    public final AccountAddress account;
    public final SigningMessage message;
    public final TransactionAuthenticator authenticator;
    public final ChainId chain_id;

    public SignedMessage(AccountAddress account, SigningMessage message, TransactionAuthenticator authenticator, ChainId chain_id) {
        Objects.requireNonNull(account, "account must not be null");
        Objects.requireNonNull(message, "message must not be null");
        Objects.requireNonNull(authenticator, "authenticator must not be null");
        Objects.requireNonNull(chain_id, "chain_id must not be null");
        this.account = account;
        this.message = message;
        this.authenticator = authenticator;
        this.chain_id = chain_id;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.account.serialize(serializer);
        this.message.serialize(serializer);
        this.authenticator.serialize(serializer);
        this.chain_id.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static SignedMessage deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.account = AccountAddress.deserialize(deserializer);
        builder.message = SigningMessage.deserialize(deserializer);
        builder.authenticator = TransactionAuthenticator.deserialize(deserializer);
        builder.chain_id = ChainId.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static SignedMessage bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        SignedMessage value = SignedMessage.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedMessage other = (SignedMessage)obj;
        if (!Objects.equals(this.account, other.account)) {
            return false;
        }
        if (!Objects.equals(this.message, other.message)) {
            return false;
        }
        if (!Objects.equals(this.authenticator, other.authenticator)) {
            return false;
        }
        return Objects.equals(this.chain_id, other.chain_id);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.account != null ? this.account.hashCode() : 0);
        value = 31 * value + (this.message != null ? this.message.hashCode() : 0);
        value = 31 * value + (this.authenticator != null ? this.authenticator.hashCode() : 0);
        value = 31 * value + (this.chain_id != null ? this.chain_id.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public AccountAddress account;
        public SigningMessage message;
        public TransactionAuthenticator authenticator;
        public ChainId chain_id;

        public SignedMessage build() {
            return new SignedMessage(this.account, this.message, this.authenticator, this.chain_id);
        }
    }
}

