/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.List;
import java.util.Objects;
import org.starcoin.types.Identifier;
import org.starcoin.types.ModuleId;
import org.starcoin.types.TraitHelpers;
import org.starcoin.types.TypeTag;

public final class ScriptFunction {
    public final ModuleId module;
    public final Identifier function;
    public final List<TypeTag> ty_args;
    public final List<Bytes> args;

    public ScriptFunction(ModuleId module, Identifier function, List<TypeTag> ty_args, List<Bytes> args) {
        Objects.requireNonNull(module, "module must not be null");
        Objects.requireNonNull(function, "function must not be null");
        Objects.requireNonNull(ty_args, "ty_args must not be null");
        Objects.requireNonNull(args, "args must not be null");
        this.module = module;
        this.function = function;
        this.ty_args = ty_args;
        this.args = args;
    }

    public static ScriptFunction deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.module = ModuleId.deserialize(deserializer);
        builder.function = Identifier.deserialize(deserializer);
        builder.ty_args = TraitHelpers.deserialize_vector_TypeTag(deserializer);
        builder.args = TraitHelpers.deserialize_vector_bytes(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static ScriptFunction bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        ScriptFunction value = ScriptFunction.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.module.serialize(serializer);
        this.function.serialize(serializer);
        TraitHelpers.serialize_vector_TypeTag(this.ty_args, serializer);
        TraitHelpers.serialize_vector_bytes(this.args, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptFunction other = (ScriptFunction)obj;
        if (!Objects.equals(this.module, other.module)) {
            return false;
        }
        if (!Objects.equals(this.function, other.function)) {
            return false;
        }
        if (!Objects.equals(this.ty_args, other.ty_args)) {
            return false;
        }
        return Objects.equals(this.args, other.args);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.module != null ? this.module.hashCode() : 0);
        value = 31 * value + (this.function != null ? this.function.hashCode() : 0);
        value = 31 * value + (this.ty_args != null ? this.ty_args.hashCode() : 0);
        value = 31 * value + (this.args != null ? this.args.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public ModuleId module;
        public Identifier function;
        public List<TypeTag> ty_args;
        public List<Bytes> args;

        public ScriptFunction build() {
            return new ScriptFunction(this.module, this.function, this.ty_args, this.args);
        }
    }
}

