/*
 * Decompiled with CFR 0.152.
 */
package com.novi.serde;

import com.novi.serde.Unsigned;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Bytes {
    private static final Bytes EMPTY = new Bytes(new byte[0]);
    private final byte[] content;

    public Bytes(byte[] content) {
        Objects.requireNonNull(content, "content must not be null");
        this.content = content;
    }

    public static Bytes empty() {
        return EMPTY;
    }

    public static Bytes valueOf(byte[] content) {
        Objects.requireNonNull(content, "content must not be null");
        if (content.length == 0) {
            return EMPTY;
        }
        return new Bytes((byte[])content.clone());
    }

    public static Bytes fromList(List<@Unsigned Byte> listBytes) {
        Objects.requireNonNull(listBytes, "list bytes must not be null");
        byte[] content = new byte[listBytes.size()];
        int i = 0;
        for (Byte item : listBytes) {
            content[i] = item;
            ++i;
        }
        return Bytes.valueOf(content);
    }

    public List<@Unsigned Byte> toList() {
        ArrayList<@Unsigned Byte> result = new ArrayList<Byte>();
        for (byte item : (byte[])this.content.clone()) {
            result.add(item);
        }
        return result;
    }

    public byte[] content() {
        return (byte[])this.content.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bytes other = (Bytes)obj;
        return Arrays.equals(this.content, other.content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }
}

