/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.starcoin.api.JsonRPCClient;
import org.starcoin.bean.ListResource;
import org.starcoin.bean.ListResourceOption;
import org.starcoin.bean.Resource;
import org.starcoin.bean.TokenInfo;
import org.starcoin.jsonrpc.client.JSONRPC2Session;
import org.starcoin.jsonrpc.client.JSONRPC2SessionException;

public class StateRPCClient {
    private static Logger logger = LoggerFactory.getLogger(StateRPCClient.class);
    JSONRPC2Session session;

    public StateRPCClient(URL baseUrl) {
        this.session = new JSONRPC2Session(baseUrl);
    }

    public ListResource getState(String address) throws JSONRPC2SessionException {
        JsonRPCClient<ListResource> client = new JsonRPCClient<ListResource>();
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(address);
        ListResourceOption option = new ListResourceOption();
        option.setDecode(true);
        param.add(option);
        try {
            return client.getObjectParseJackson(this.session, "state.list_resource", param, 0, ListResource.class);
        }
        catch (IOException e) {
            logger.error("get state error:", (Throwable)e);
            return null;
        }
    }

    public ListResource getState(String address, boolean isDecode, String state_root) throws JSONRPC2SessionException {
        JsonRPCClient<ListResource> client = new JsonRPCClient<ListResource>();
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(address);
        ListResourceOption option = new ListResourceOption();
        option.setDecode(isDecode);
        option.setStateRoot(state_root);
        param.add(option);
        try {
            return client.getObjectParseJackson(this.session, "state.list_resource", param, 0, ListResource.class);
        }
        catch (IOException e) {
            logger.error("get state error:", (Throwable)e);
            return null;
        }
    }

    public TokenInfo getTokenInfo(String address, String tokenCode) throws JSONRPC2SessionException, JsonProcessingException {
        JsonRPCClient<TokenInfo> client = new JsonRPCClient<TokenInfo>();
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(address);
        param.add(this.tokenInfoParameter(tokenCode));
        ListResourceOption option = new ListResourceOption();
        option.setDecode(true);
        param.add(option);
        TokenInfo tokenInfo = client.getSubObject(this.session, "state.get_resource", param, 0, "json", TokenInfo.class);
        if (tokenInfo != null) {
            tokenInfo.setTokenCode(tokenCode);
        }
        return tokenInfo;
    }

    @Deprecated
    public long getAddressAmount(String address, String token) {
        try {
            ListResource listResource = this.getState(address);
            if (listResource == null) {
                return -1L;
            }
            Map<String, Resource> resourceMap = listResource.getResources();
            JsonNode node = resourceMap.get(this.getResourceMapTokenKey(token)).getJson().get("token");
            if (node != null) {
                return node.get("value").asLong();
            }
        }
        catch (Exception e) {
            logger.error("get amount error:", (Throwable)e);
        }
        return 0L;
    }

    public BigInteger getAddressAmountValue(String address, String token) {
        try {
            ListResource listResource = this.getState(address);
            if (listResource == null) {
                return BigInteger.valueOf(-1L);
            }
            Map<String, Resource> resourceMap = listResource.getResources();
            JsonNode node = resourceMap.get(this.getResourceMapTokenKey(token)).getJson().get("token");
            if (node != null) {
                return new BigInteger(node.get("value").asText());
            }
        }
        catch (Exception e) {
            logger.error("get amount error:", (Throwable)e);
        }
        return BigInteger.valueOf(0L);
    }

    private String getResourceMapTokenKey(String token) {
        return "0x00000000000000000000000000000001::Account::Balance<" + token + ">";
    }

    private String tokenInfoParameter(String code) {
        return "0x1::Token::TokenInfo<" + code + ">";
    }

    private ListResource getListResource(String address, List<String> resourceTypes, String stateRoot, Integer startIndex, Integer maxSize) throws JSONRPC2SessionException {
        JsonRPCClient<ListResource> client = new JsonRPCClient<ListResource>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        parameter.add(address);
        ListResourceOption option = new ListResourceOption();
        option.setDecode(true);
        option.setResourceTypes(resourceTypes);
        option.setStateRoot(stateRoot);
        option.setStartIndex(startIndex);
        option.setMaxSize(maxSize);
        parameter.add(option);
        return client.getObject(this.session, "state.list_resource", parameter, 0, ListResource.class);
    }

    public ListResource getAllResourcesByAddress(String address) throws JSONRPC2SessionException {
        return this.getListResource(address, null, null, null, null);
    }

    public ListResource getAllResourcesByResourceTypes(String address, List<String> resourceTypes) throws JSONRPC2SessionException {
        return this.getListResource(address, resourceTypes, null, null, null);
    }

    public ListResource getAllResourcesByTypeTags(String address, List<String> typeTags) throws JSONRPC2SessionException {
        return this.getListResource(address, typeTags, null, null, null);
    }

    public ListResource getResourceListByPage(String address, int startIndex, int maxSize) throws JSONRPC2SessionException {
        return this.getListResource(address, null, null, startIndex, maxSize);
    }
}

