/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.jsonrpc.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.starcoin.jsonrpc.JSONRPC2Request;
import org.starcoin.jsonrpc.JSONRPC2Response;
import org.starcoin.jsonrpc.client.JSONRPC2SessionException;

public class JSONRPC2Session {
    public static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
    private URL url;

    public JSONRPC2Session(URL url) {
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The URL protocol must be HTTP or HTTPS");
        }
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("The server URL must not be null");
        }
        this.url = url;
    }

    public JSONRPC2Response send(JSONRPC2Request request) throws JSONRPC2SessionException {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("jsonrpc", "2.0");
        bodyMap.put("method", request.getMethod());
        bodyMap.put("id", request.getID() == null ? UUID.randomUUID().toString() : request.getID());
        bodyMap.put("params", request.getParams());
        try {
            RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.getObjectMapper().writeValueAsString(bodyMap));
            Request okRequest = new Request.Builder().post(body).url(this.url).build();
            Response response = this.okHttpClient.newCall(okRequest).execute();
            if (!response.isSuccessful()) {
                throw new RuntimeException("JSON RPC error. Response is NOT successful." + response);
            }
            if (response.body() == null) {
                throw new JSONRPC2SessionException("Response body is null.");
            }
            return (JSONRPC2Response)this.getObjectMapper().readValue(response.body().string(), JSONRPC2Response.class);
        }
        catch (IOException ioException) {
            throw new JSONRPC2SessionException("Send JSON RPC IO error.", ioException);
        }
    }

    private ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

