/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format.jackson.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Map;
import org.starcoin.serde.format.ContainerFormat;
import org.starcoin.serde.format.Format;
import org.starcoin.serde.format.NamedFormat;
import org.starcoin.serde.format.NamedVariantFormat;
import org.starcoin.serde.format.VariantFormat;
import org.starcoin.serde.format.jackson.ContainerFormatDeserializer;
import org.starcoin.serde.format.jackson.FormatDeserializer;
import org.starcoin.serde.format.jackson.NamedFormatDeserializer;
import org.starcoin.serde.format.jackson.NamedVariantFormatDeserializer;
import org.starcoin.serde.format.jackson.VariantFormatDeserializer;

public class MappingUtils {
    private MappingUtils() {
    }

    public static Map<String, ContainerFormat> toContainerFormatMap(ObjectMapper objectMapper, Map<String, Object> map) {
        return (Map)objectMapper.convertValue(map, (TypeReference)new TypeReference<Map<String, ContainerFormat>>(){});
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ContainerFormat.class, (JsonDeserializer)new ContainerFormatDeserializer());
        module.addDeserializer(Format.class, (JsonDeserializer)new FormatDeserializer());
        module.addDeserializer(NamedFormat.class, (JsonDeserializer)new NamedFormatDeserializer());
        module.addDeserializer(Format.class, (JsonDeserializer)new FormatDeserializer());
        module.addDeserializer(NamedVariantFormat.class, (JsonDeserializer)new NamedVariantFormatDeserializer());
        module.addDeserializer(VariantFormat.class, (JsonDeserializer)new VariantFormatDeserializer());
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }
}

