/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.ChainId;
import org.starcoin.types.TransactionPayload;

public final class RawUserTransaction {
    public final AccountAddress sender;
    public final @Unsigned Long sequence_number;
    public final TransactionPayload payload;
    public final @Unsigned Long max_gas_amount;
    public final @Unsigned Long gas_unit_price;
    public final String gas_token_code;
    public final @Unsigned Long expiration_timestamp_secs;
    public final ChainId chain_id;

    public RawUserTransaction(AccountAddress sender, @Unsigned Long sequence_number, TransactionPayload payload, @Unsigned Long max_gas_amount, @Unsigned Long gas_unit_price, String gas_token_code, @Unsigned Long expiration_timestamp_secs, ChainId chain_id) {
        Objects.requireNonNull(sender, "sender must not be null");
        Objects.requireNonNull(sequence_number, "sequence_number must not be null");
        Objects.requireNonNull(payload, "payload must not be null");
        Objects.requireNonNull(max_gas_amount, "max_gas_amount must not be null");
        Objects.requireNonNull(gas_unit_price, "gas_unit_price must not be null");
        Objects.requireNonNull(gas_token_code, "gas_token_code must not be null");
        Objects.requireNonNull(expiration_timestamp_secs, "expiration_timestamp_secs must not be null");
        Objects.requireNonNull(chain_id, "chain_id must not be null");
        this.sender = sender;
        this.sequence_number = sequence_number;
        this.payload = payload;
        this.max_gas_amount = max_gas_amount;
        this.gas_unit_price = gas_unit_price;
        this.gas_token_code = gas_token_code;
        this.expiration_timestamp_secs = expiration_timestamp_secs;
        this.chain_id = chain_id;
    }

    public static RawUserTransaction deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.sender = AccountAddress.deserialize(deserializer);
        builder.sequence_number = deserializer.deserialize_u64();
        builder.payload = TransactionPayload.deserialize(deserializer);
        builder.max_gas_amount = deserializer.deserialize_u64();
        builder.gas_unit_price = deserializer.deserialize_u64();
        builder.gas_token_code = deserializer.deserialize_str();
        builder.expiration_timestamp_secs = deserializer.deserialize_u64();
        builder.chain_id = ChainId.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static RawUserTransaction bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        RawUserTransaction value = RawUserTransaction.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.sender.serialize(serializer);
        serializer.serialize_u64(this.sequence_number);
        this.payload.serialize(serializer);
        serializer.serialize_u64(this.max_gas_amount);
        serializer.serialize_u64(this.gas_unit_price);
        serializer.serialize_str(this.gas_token_code);
        serializer.serialize_u64(this.expiration_timestamp_secs);
        this.chain_id.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawUserTransaction other = (RawUserTransaction)obj;
        if (!Objects.equals(this.sender, other.sender)) {
            return false;
        }
        if (!Objects.equals(this.sequence_number, other.sequence_number)) {
            return false;
        }
        if (!Objects.equals(this.payload, other.payload)) {
            return false;
        }
        if (!Objects.equals(this.max_gas_amount, other.max_gas_amount)) {
            return false;
        }
        if (!Objects.equals(this.gas_unit_price, other.gas_unit_price)) {
            return false;
        }
        if (!Objects.equals(this.gas_token_code, other.gas_token_code)) {
            return false;
        }
        if (!Objects.equals(this.expiration_timestamp_secs, other.expiration_timestamp_secs)) {
            return false;
        }
        return Objects.equals(this.chain_id, other.chain_id);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.sender != null ? this.sender.hashCode() : 0);
        value = 31 * value + (this.sequence_number != null ? this.sequence_number.hashCode() : 0);
        value = 31 * value + (this.payload != null ? this.payload.hashCode() : 0);
        value = 31 * value + (this.max_gas_amount != null ? this.max_gas_amount.hashCode() : 0);
        value = 31 * value + (this.gas_unit_price != null ? this.gas_unit_price.hashCode() : 0);
        value = 31 * value + (this.gas_token_code != null ? this.gas_token_code.hashCode() : 0);
        value = 31 * value + (this.expiration_timestamp_secs != null ? this.expiration_timestamp_secs.hashCode() : 0);
        value = 31 * value + (this.chain_id != null ? this.chain_id.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public AccountAddress sender;
        public @Unsigned Long sequence_number;
        public TransactionPayload payload;
        public @Unsigned Long max_gas_amount;
        public @Unsigned Long gas_unit_price;
        public String gas_token_code;
        public @Unsigned Long expiration_timestamp_secs;
        public ChainId chain_id;

        public RawUserTransaction build() {
            return new RawUserTransaction(this.sender, this.sequence_number, this.payload, this.max_gas_amount, this.gas_unit_price, this.gas_token_code, this.expiration_timestamp_secs, this.chain_id);
        }
    }
}

