/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format.cli;

import com.beust.jcommander.JCommander;
import java.util.List;
import java.util.stream.Collectors;
import org.starcoin.serde.format.cli.SerdeGenJavaArgs;
import org.starcoin.serde.format.jackson.utils.MappingUtils;
import org.starcoin.serde.format.utils.SerdeGenJavaUtils;

public class SerdeGenJava {
    public static void main(String[] args) {
        SerdeGenJavaArgs serdeGenJavaArgs = new SerdeGenJavaArgs();
        JCommander jCommander = JCommander.newBuilder().addObject((Object)serdeGenJavaArgs).build();
        jCommander.parse(args);
        if (serdeGenJavaArgs.isHelp()) {
            jCommander.usage();
            return;
        }
        String targetSourceDirectoryPath = serdeGenJavaArgs.getTargetSourceDirectoryPath();
        List<SerdeGenJavaUtils.SerdeFormatFile> serdeFormatFiles = serdeGenJavaArgs.getParameters().stream().map(i -> {
            String[] fields = i.split(":");
            if (fields.length < 2) {
                throw new IllegalArgumentException("List item error.");
            }
            String formatFilePath = fields[0];
            String packageName = fields[1];
            return new SerdeGenJavaUtils.SerdeFormatFile(formatFilePath, packageName, targetSourceDirectoryPath);
        }).collect(Collectors.toList());
        SerdeGenJavaUtils.processSerdeFormatFiles(serdeGenJavaArgs.getWorkingDirectory(), serdeGenJavaArgs.getSerdegenPath(), serdeFormatFiles, MappingUtils.getObjectMapper(), serdeGenJavaArgs.getTempYamlFileExtension(), serdeGenJavaArgs.getOnlyRetainDependenciesOfLast());
        System.out.println("All seem ok.");
    }
}

