/*
 * Decompiled with CFR 0.152.
 */
package com.novi.serde;

import com.novi.serde.Bytes;
import com.novi.serde.Int128;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unit;
import com.novi.serde.Unsigned;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public abstract class BinarySerializer
implements Serializer {
    protected MyByteArrayOutputStream output = new MyByteArrayOutputStream();
    private long containerDepthBudget;

    public BinarySerializer(long maxContainerDepth) {
        this.containerDepthBudget = maxContainerDepth;
    }

    @Override
    public void increase_container_depth() throws SerializationError {
        if (this.containerDepthBudget == 0L) {
            throw new SerializationError("Exceeded maximum container depth");
        }
        --this.containerDepthBudget;
    }

    @Override
    public void decrease_container_depth() {
        ++this.containerDepthBudget;
    }

    @Override
    public void serialize_str(String value) throws SerializationError {
        this.serialize_bytes(new Bytes(value.getBytes()));
    }

    @Override
    public void serialize_bytes(Bytes value) throws SerializationError {
        byte[] content = value.content();
        this.serialize_len(content.length);
        this.output.write(content, 0, content.length);
    }

    @Override
    public void serialize_bool(Boolean value) throws SerializationError {
        this.output.write(value != false ? 1 : 0);
    }

    @Override
    public void serialize_unit(Unit value) throws SerializationError {
    }

    @Override
    public void serialize_char(Character value) throws SerializationError {
        throw new SerializationError("Not implemented: serialize_char");
    }

    @Override
    public void serialize_u8(@Unsigned Byte value) throws SerializationError {
        this.output.write(value.byteValue());
    }

    @Override
    public void serialize_u16(@Unsigned Short value) throws SerializationError {
        short val = value;
        this.output.write((byte)(val >>> 0));
        this.output.write((byte)(val >>> 8));
    }

    @Override
    public void serialize_u32(@Unsigned Integer value) throws SerializationError {
        int val = value;
        this.output.write((byte)(val >>> 0));
        this.output.write((byte)(val >>> 8));
        this.output.write((byte)(val >>> 16));
        this.output.write((byte)(val >>> 24));
    }

    @Override
    public void serialize_u64(@Unsigned Long value) throws SerializationError {
        long val = value;
        this.output.write((byte)(val >>> 0));
        this.output.write((byte)(val >>> 8));
        this.output.write((byte)(val >>> 16));
        this.output.write((byte)(val >>> 24));
        this.output.write((byte)(val >>> 32));
        this.output.write((byte)(val >>> 40));
        this.output.write((byte)(val >>> 48));
        this.output.write((byte)(val >>> 56));
    }

    @Override
    public void serialize_u128(@Unsigned @Int128 BigInteger value) throws SerializationError {
        int i;
        if (value.compareTo(BigInteger.ZERO) < 0 || !value.shiftRight(128).equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("Invalid value for an unsigned int128");
        }
        byte[] content = value.toByteArray();
        assert (content.length <= 16 || content[0] == 0);
        int len = Math.min(content.length, 16);
        for (i = 0; i < len; ++i) {
            this.output.write(content[content.length - 1 - i]);
        }
        for (i = len; i < 16; ++i) {
            this.output.write(0);
        }
    }

    @Override
    public void serialize_i8(Byte value) throws SerializationError {
        this.serialize_u8(value);
    }

    @Override
    public void serialize_i16(Short value) throws SerializationError {
        this.serialize_u16(value);
    }

    @Override
    public void serialize_i32(Integer value) throws SerializationError {
        this.serialize_u32(value);
    }

    @Override
    public void serialize_i64(Long value) throws SerializationError {
        this.serialize_u64(value);
    }

    @Override
    public void serialize_i128(@Int128 BigInteger value) throws SerializationError {
        if (value.compareTo(BigInteger.ZERO) >= 0) {
            if (!value.shiftRight(127).equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException("Invalid value for a signed int128");
            }
            this.serialize_u128(value);
        } else {
            if (!value.add(BigInteger.ONE).negate().shiftRight(127).equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException("Invalid value for a signed int128");
            }
            this.serialize_u128(value.add(BigInteger.ONE.shiftLeft(128)));
        }
    }

    @Override
    public void serialize_option_tag(boolean value) throws SerializationError {
        this.output.write(value ? 1 : 0);
    }

    @Override
    public int get_buffer_offset() {
        return this.output.size();
    }

    @Override
    public byte[] get_bytes() {
        return this.output.toByteArray();
    }

    public static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

