/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.starcoin.serde.format.IReferenceContainerType;

public abstract class Format
implements IReferenceContainerType {

    public static class TupleArray
    extends Format {
        private Format content;
        private int size;

        public TupleArray(Format content, int size) {
            this.content = content;
            this.size = size;
        }

        public Format getContent() {
            return this.content;
        }

        public int getSize() {
            return this.size;
        }

        public String toString() {
            return "TupleArray{content=" + this.content + ", size=" + this.size + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.content.referencedContainerTypeNames();
        }
    }

    public static class Tuple
    extends Format {
        private List<Format> formats;

        public Tuple(List<Format> formats) {
            this.formats = formats;
        }

        public List<Format> getFormats() {
            return this.formats;
        }

        public String toString() {
            return "Tuple{formats=" + this.formats + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.formats.stream().flatMap(f -> f.referencedContainerTypeNames().stream()).collect(Collectors.toList());
        }
    }

    public static class Map
    extends Format {
        private Format key;
        private Format value;

        public Map(Format key, Format value) {
            this.key = key;
            this.value = value;
        }

        public Format getKey() {
            return this.key;
        }

        public Format getValue() {
            return this.value;
        }

        public String toString() {
            return "Map{key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return Stream.concat(this.key.referencedContainerTypeNames().stream(), this.value.referencedContainerTypeNames().stream()).collect(Collectors.toList());
        }
    }

    public static class Seq
    extends Format {
        private Format format;

        public Seq(Format format) {
            this.format = format;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "Seq{format=" + this.format + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.format.referencedContainerTypeNames();
        }
    }

    public static class Option
    extends Format {
        private Format format;

        public Option(Format format) {
            this.format = format;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "Option{format=" + this.format + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return this.format.referencedContainerTypeNames();
        }
    }

    public static class TypeName
    extends Format {
        private String name;

        public TypeName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "TypeName{name='" + this.name + '\'' + '}';
        }

        @Override
        public List<String> referencedContainerTypeNames() {
            return Collections.singletonList(this.name);
        }
    }

    public static class Primitive
    extends Format {
        public static final Primitive UNIT = new Primitive("UNIT");
        public static final Primitive BOOL = new Primitive("BOOL");
        public static final Primitive I8 = new Primitive("I8");
        public static final Primitive I16 = new Primitive("I16");
        public static final Primitive I32 = new Primitive("I32");
        public static final Primitive I64 = new Primitive("I64");
        public static final Primitive I128 = new Primitive("I128");
        public static final Primitive U8 = new Primitive("U8");
        public static final Primitive U16 = new Primitive("U16");
        public static final Primitive U32 = new Primitive("U32");
        public static final Primitive U64 = new Primitive("U64");
        public static final Primitive U128 = new Primitive("U128");
        public static final Primitive F32 = new Primitive("F32");
        public static final Primitive F64 = new Primitive("F64");
        public static final Primitive CHAR = new Primitive("CHAR");
        public static final Primitive STR = new Primitive("STR");
        public static final Primitive BYTES = new Primitive("BYTES");
        private String type;

        public Primitive(String type) {
            this.type = type;
        }

        public static Primitive valueOf(String s) {
            if ("UNIT".equals(s)) {
                return UNIT;
            }
            if ("BOOL".equals(s)) {
                return BOOL;
            }
            if ("U8".equals(s)) {
                return U8;
            }
            if ("U16".equals(s)) {
                return U16;
            }
            if ("U32".equals(s)) {
                return U32;
            }
            if ("U64".equals(s)) {
                return U64;
            }
            if ("U128".equals(s)) {
                return U128;
            }
            if ("I8".equals(s)) {
                return I8;
            }
            if ("I16".equals(s)) {
                return I16;
            }
            if ("I32".equals(s)) {
                return I32;
            }
            if ("I64".equals(s)) {
                return I64;
            }
            if ("I128".equals(s)) {
                return I128;
            }
            if ("F32".equals(s)) {
                return F32;
            }
            if ("F64".equals(s)) {
                return F64;
            }
            if ("CHAR".equals(s)) {
                return CHAR;
            }
            if ("STR".equals(s)) {
                return STR;
            }
            if ("BYTES".equals(s)) {
                return BYTES;
            }
            throw new IllegalArgumentException("Unknown type name: " + s);
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "Primitive{type='" + this.type + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Primitive primitive = (Primitive)o;
            return this.type.equals(primitive.type);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public List referencedContainerTypeNames() {
            return Collections.EMPTY_LIST;
        }
    }
}

