/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.jsonrpc;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.starcoin.jsonrpc.JSONRPC2Error;

public class JSONRPC2Response {
    @JsonProperty(value="jsonrpc")
    private String jsonRPCVersion;
    private Object result = null;
    private JSONRPC2Error error = null;
    private Object id = null;

    public JSONRPC2Response() {
    }

    public JSONRPC2Response(Object result, Object id) {
        this.setResult(result);
        this.setID(id);
    }

    public JSONRPC2Response(Object id) {
        this.setResult(null);
        this.setID(id);
    }

    public JSONRPC2Response(JSONRPC2Error error, Object id) {
        this.setError(error);
        this.setID(id);
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
        this.error = null;
    }

    public JSONRPC2Error getError() {
        return this.error;
    }

    public void setError(JSONRPC2Error error) {
        if (error == null) {
            throw new IllegalArgumentException("The error object cannot be null");
        }
        this.error = error;
        this.result = null;
    }

    public boolean indicatesSuccess() {
        return this.error == null;
    }

    public Object getID() {
        return this.id;
    }

    public void setID(Object id) {
        this.id = id == null || id instanceof Boolean || id instanceof Number || id instanceof String ? id : id.toString();
    }

    public String getJsonRPCVersion() {
        return this.jsonRPCVersion;
    }

    public void setJsonRPCVersion(String jsonRPCVersion) {
        this.jsonRPCVersion = jsonRPCVersion;
    }

    public String toString() {
        return "JSONRPC2Response{jsonrpc='" + this.jsonRPCVersion + '\'' + ", result=" + this.result + ", error=" + this.error + ", id=" + this.id + '}';
    }
}

