/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.google.common.primitives.Bytes;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.List;
import java.util.Objects;
import org.starcoin.types.HashValue;
import org.starcoin.types.TraitHelpers;

public final class SigningMessage {
    public static final String CLASS_NAME = "SigningMessage";
    public static final byte[] PREFIX_BYTES = HashValue.sha3Of((byte[])"STARCOIN::SigningMessage".getBytes()).value.content();
    public final List<@Unsigned Byte> value;

    public SigningMessage(List<@Unsigned Byte> value) {
        Objects.requireNonNull(value, "value must not be null");
        this.value = value;
    }

    public static byte[] hashBytes(SigningMessage signingMessage) throws SerializationError {
        return Bytes.concat((byte[][])new byte[][]{PREFIX_BYTES, signingMessage.bcsSerialize()});
    }

    public static SigningMessage deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.value = TraitHelpers.deserialize_vector_u8(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static SigningMessage bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        SigningMessage value = SigningMessage.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        TraitHelpers.serialize_vector_u8(this.value, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SigningMessage other = (SigningMessage)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public List<@Unsigned Byte> value;

        public SigningMessage build() {
            return new SigningMessage(this.value);
        }
    }
}

